/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.converter.FontConverter;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontVerter {
    private static Logger log = LoggerFactory.getLogger(FontVerter.class);
    private static List<Class> adapters;
    private static final Object adapterLock;

    public static FVFont convertFont(FVFont inputFont, FontFormat convertTo) throws IOException {
        FontConverter converter = inputFont.createConverterForType(convertTo);
        return converter.convertFont(inputFont);
    }

    public static FVFont convertFont(byte[] inputFontData, FontFormat convertTo) throws IOException {
        FVFont inputFont = FontVerter.readFont(inputFontData);
        return FontVerter.convertFont(inputFont, convertTo);
    }

    public static FVFont convertFont(File inputFontData, FontFormat convertTo) throws IOException {
        byte[] data = FileUtils.readFileToByteArray((File)inputFontData);
        return FontVerter.convertFont(data, convertTo);
    }

    public static FVFont convertFont(String inputFontData, FontFormat convertTo) throws IOException {
        byte[] data = FileUtils.readFileToByteArray((File)new File(inputFontData));
        return FontVerter.convertFont(data, convertTo);
    }

    public static FVFont readFont(File fontFile) throws IOException {
        byte[] data = FileUtils.readFileToByteArray((File)fontFile);
        return FontVerter.readFont(data);
    }

    public static FVFont readFont(String fontFile) throws IOException {
        return FontVerter.readFont(new File(fontFile));
    }

    public static FVFont readFont(byte[] fontData) throws IOException {
        FVFont adapter;
        FontVerter.registerFontAdapters();
        for (Class adapterOn : adapters) {
            adapter = FontVerter.tryReadFontAdapter(fontData, adapterOn);
            if (adapter == null) continue;
            return adapter;
        }
        for (Class adapterOn : adapters) {
            try {
                adapter = FontVerter.parseFont(fontData, adapterOn);
                if (adapter == null) continue;
                return adapter;
            }
            catch (Exception ex) {
                throw new IOException("FontVerter could not read the given font file.", ex);
            }
        }
        throw new IOException("FontVerter could not detect the input font's type.");
    }

    private static FVFont tryReadFontAdapter(byte[] fontData, Class<? extends FVFont> adapterOn) throws IOException {
        try {
            return FontVerter.parseFont(fontData, adapterOn);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static FVFont parseFont(byte[] fontData, Class<? extends FVFont> adapterOn) throws InstantiationException, IllegalAccessException, IOException {
        FVFont adapter = adapterOn.newInstance();
        if (adapter.detectFormat(fontData)) {
            adapter.read(fontData);
            return adapter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerFontAdapters() {
        Object object = adapterLock;
        synchronized (object) {
            if (adapters == null) {
                Reflections reflections = new Reflections("org.mabb.fontverter", new Scanner[0]);
                Set adapterClasses = reflections.getSubTypesOf(FVFont.class);
                Class[] adapterArr = adapterClasses.toArray(new Class[adapterClasses.size()]);
                adapters = Arrays.asList(adapterArr);
                Class cffAdapter = null;
                for (Class adapterOn : adapters) {
                    if (!adapterOn.getSimpleName().contains("CffFont")) continue;
                    cffAdapter = adapterOn;
                }
                int cffIndex = adapters.indexOf(cffAdapter);
                adapters.set(cffIndex, adapters.get(adapters.size() - 1));
                adapters.set(adapters.size() - 1, cffAdapter);
                adapters = FontVerter.removeAbstractClasses(adapters);
            }
        }
    }

    private static List<Class> removeAbstractClasses(List<Class> classes) {
        ArrayList<Class> filtered = new ArrayList<Class>();
        for (Class adapterOn : classes) {
            if (Modifier.isAbstract(adapterOn.getModifiers())) continue;
            filtered.add(adapterOn);
        }
        return filtered;
    }

    static {
        adapterLock = new Object();
    }

    public static enum FontFormat {
        OTF,
        WOFF1,
        WOFF2,
        BARE_CFF,
        EOT;

        public static final FontFormat TTF;

        public static FontFormat fromString(String value) {
            if (value.equalsIgnoreCase("WOFF")) {
                return WOFF1;
            }
            if (value.equalsIgnoreCase("OpenType")) {
                return OTF;
            }
            if (value.equalsIgnoreCase("TrueType")) {
                return OTF;
            }
            if (value.equalsIgnoreCase("EOT")) {
                return EOT;
            }
            return FontFormat.valueOf(value.toUpperCase());
        }

        static {
            TTF = OTF;
        }
    }
}

