/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;

class SourcesAsResourcesHelper {
    SourcesAsResourcesHelper() {
    }

    static List<String> filterSourceRoots(Log log, Iterable<Resource> resources, Iterable<String> sourceRoots) {
        Set<String> resourceDirs = SourcesAsResourcesHelper.prepareResources(resources);
        ArrayList<String> filteredSourceRoots = new ArrayList<String>();
        for (String sourceRoot : sourceRoots) {
            if (!SourcesAsResourcesHelper.checkSourceRoot(log, resourceDirs, sourceRoot)) continue;
            filteredSourceRoots.add(sourceRoot);
        }
        return filteredSourceRoots;
    }

    private static Set<String> prepareResources(Iterable<Resource> resources) {
        LinkedHashSet<String> resourceDirs = new LinkedHashSet<String>();
        for (Resource resource : resources) {
            resourceDirs.add(SourcesAsResourcesHelper.ensureTrailingSlash(resource.getDirectory()));
        }
        return resourceDirs;
    }

    static String ensureTrailingSlash(String directory) {
        if (directory.endsWith("/")) {
            return directory;
        }
        return directory + "/";
    }

    private static boolean checkSourceRoot(Log log, Set<String> resourceDirs, String sourceRoot) {
        sourceRoot = SourcesAsResourcesHelper.ensureTrailingSlash(sourceRoot);
        for (String resourceDir : resourceDirs) {
            if (resourceDir.equals(sourceRoot)) {
                log.info((CharSequence)(sourceRoot + " already added as a resource folder; skipping."));
                continue;
            }
            if (!resourceDir.startsWith(sourceRoot) && !sourceRoot.startsWith(resourceDir)) continue;
            log.warn((CharSequence)String.format("Conflicting path between source folder (%s, to be added as resource) and resource (%s); skipping.", sourceRoot, resourceDir));
            return false;
        }
        return true;
    }
}

