/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

class CommandLine {
    private final Log log;
    private final MavenProject project;
    private final MavenSession session;
    private final ToolchainManager toolchainManager;
    private final Map<String, String> toolchainRequirements;
    private final String jvm;

    CommandLine(Log log, MavenProject project, MavenSession session, ToolchainManager toolchainManager, Map<String, String> toolchainRequirements, String jvm) {
        this.log = log;
        this.project = project;
        this.session = session;
        this.toolchainManager = toolchainManager;
        this.toolchainRequirements = toolchainRequirements;
        this.jvm = jvm;
    }

    void execute(Iterable<String> classpath, List<String> arguments) throws MojoExecutionException {
        int result;
        String cp = StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
        String[] args = arguments.toArray(new String[arguments.size()]);
        Commandline commandline = new Commandline();
        commandline.setWorkingDirectory(this.project.getBuild().getDirectory());
        commandline.setExecutable(this.getExecutable());
        commandline.addEnvironment("CLASSPATH", cp);
        commandline.addArguments(args);
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Classpath: " + cp));
            this.log.debug((CharSequence)("Arguments: " + CommandLineUtils.toString((String[])args)));
        }
        try {
            result = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String s) {
                    CommandLine.this.log.info((CharSequence)s);
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String s) {
                    CommandLine.this.log.warn((CharSequence)s);
                }
            });
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (result != 0) {
            throw new MojoExecutionException("GWT exited with status " + result);
        }
    }

    private String getExecutable() {
        String executable;
        if (StringUtils.isNotBlank((String)this.jvm)) {
            return this.jvm;
        }
        Toolchain tc = this.getToolchain();
        if (tc != null && StringUtils.isNotBlank((String)(executable = tc.findTool("java")))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Toolchain: " + tc));
            }
            return executable;
        }
        return Paths.get(System.getProperty("java.home"), "bin", "java").toString();
    }

    @Nullable
    private Toolchain getToolchain() {
        List tcs;
        Toolchain tc = null;
        if (this.toolchainRequirements != null && !this.toolchainRequirements.isEmpty() && (tcs = this.toolchainManager.getToolchains(this.session, "jdk", this.toolchainRequirements)) != null && !tcs.isEmpty()) {
            tc = (Toolchain)tcs.get(0);
        }
        if (tc == null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }
}

