/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.lmax.disruptor.dsl;

import net.logstash.logback.encoder.com.lmax.disruptor.BatchEventProcessor;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandlerIdentity;
import net.logstash.logback.encoder.com.lmax.disruptor.EventProcessor;
import net.logstash.logback.encoder.com.lmax.disruptor.ExceptionHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.dsl.ConsumerRepository;

public class ExceptionHandlerSetting<T> {
    private final EventHandlerIdentity handlerIdentity;
    private final ConsumerRepository consumerRepository;

    ExceptionHandlerSetting(EventHandlerIdentity handlerIdentity, ConsumerRepository consumerRepository) {
        this.handlerIdentity = handlerIdentity;
        this.consumerRepository = consumerRepository;
    }

    public void with(ExceptionHandler<? super T> exceptionHandler) {
        EventProcessor eventProcessor = this.consumerRepository.getEventProcessorFor(this.handlerIdentity);
        if (!(eventProcessor instanceof BatchEventProcessor)) {
            throw new RuntimeException("EventProcessor: " + eventProcessor + " is not a BatchEventProcessor and does not support exception handlers");
        }
        ((BatchEventProcessor)eventProcessor).setExceptionHandler(exceptionHandler);
        this.consumerRepository.getBarrierFor(this.handlerIdentity).alert();
    }
}

