/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.logstash.logback.composite.ContextJsonProvider;
import net.logstash.logback.composite.GlobalCustomFieldsJsonProvider;
import net.logstash.logback.composite.JsonProvider;
import net.logstash.logback.composite.LogstashVersionJsonProvider;
import net.logstash.logback.composite.ObjectMapperAware;
import net.logstash.logback.composite.UuidJsonProvider;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.ObjectMapper;

public class JsonProviders<Event extends DeferredProcessingAware>
implements ObjectMapperAware {
    private final List<JsonProvider<Event>> jsonProviders = new ArrayList<JsonProvider<Event>>();

    public void start() {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.start();
        }
    }

    public void stop() {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.stop();
        }
    }

    public void setContext(Context context) {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.setContext(context);
        }
    }

    public void addProvider(JsonProvider<Event> provider) {
        if (provider != null) {
            this.jsonProviders.add(provider);
        }
    }

    public void removeProvider(JsonProvider<Event> provider) {
        if (provider != null) {
            this.jsonProviders.remove(provider);
        }
    }

    public void writeTo(JsonGenerator generator, Event event) {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.writeTo(generator, event);
        }
    }

    protected void prepareForDeferredProcessing(Event event) {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            jsonProvider.prepareForDeferredProcessing(event);
        }
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        for (JsonProvider<Event> jsonProvider : this.jsonProviders) {
            if (!(jsonProvider instanceof ObjectMapperAware)) continue;
            ((ObjectMapperAware)((Object)jsonProvider)).setObjectMapper(objectMapper);
        }
    }

    public List<JsonProvider<Event>> getProviders() {
        return Collections.unmodifiableList(this.jsonProviders);
    }

    public void addContext(ContextJsonProvider<Event> provider) {
        this.addProvider(provider);
    }

    public void addGlobalCustomFields(GlobalCustomFieldsJsonProvider<Event> provider) {
        this.addProvider(provider);
    }

    public void addUuid(UuidJsonProvider<Event> provider) {
        this.addProvider(provider);
    }

    public void addVersion(LogstashVersionJsonProvider<Event> provider) {
        this.addProvider(provider);
    }
}

