/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.Objects;

class FastISOTimestampFormatter {
    private static ThreadLocal<StringBuilder> STRING_BUILDERS = ThreadLocal.withInitial(() -> new StringBuilder(40));
    private static final int[] DECIMALS = new int[]{100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10};
    private final DateTimeFormatter formatter;
    private ZoneOffsetState zoneOffsetState;
    private final boolean trimMillis;

    FastISOTimestampFormatter(DateTimeFormatter formatter, boolean trimMillis) {
        this.formatter = Objects.requireNonNull(formatter);
        this.trimMillis = trimMillis;
        if (formatter.getZone() == null) {
            throw new IllegalArgumentException("formatter must be configured with a Zone override to format Instant");
        }
    }

    public String format(Instant tstamp) {
        ZoneOffsetState current = this.zoneOffsetState;
        if (current == null || !current.canFormat(tstamp)) {
            this.zoneOffsetState = current = new ZoneOffsetState(tstamp);
        }
        return current.format(tstamp);
    }

    public static FastISOTimestampFormatter isoOffsetDateTime(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(zoneId), true);
    }

    public static FastISOTimestampFormatter isoZonedDateTime(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_ZONED_DATE_TIME.withZone(zoneId), true);
    }

    public static FastISOTimestampFormatter isoLocalDateTime(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(zoneId), true);
    }

    public static FastISOTimestampFormatter isoDateTime(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_DATE_TIME.withZone(zoneId), true);
    }

    public static FastISOTimestampFormatter isoInstant(ZoneId zoneId) {
        return new FastISOTimestampFormatter(DateTimeFormatter.ISO_INSTANT.withZone(zoneId), false);
    }

    String buildFromFormatter(Instant tstamp) {
        return this.formatter.format(tstamp);
    }

    private class ZoneOffsetState {
        private final Instant zoneTransitionStart;
        private final Instant zoneTransitionStop;
        private final boolean cachingEnabled;
        private TimestampPeriod cachedTimestampPeriod;

        ZoneOffsetState(Instant tstamp) {
            ZoneRules rules = FastISOTimestampFormatter.this.formatter.getZone().getRules();
            if (rules.isFixedOffset()) {
                this.zoneTransitionStart = Instant.MIN;
                this.zoneTransitionStop = Instant.MAX;
            } else {
                ZoneOffsetTransition previousZoneOffsetTransition = rules.previousTransition(tstamp);
                this.zoneTransitionStart = previousZoneOffsetTransition == null ? Instant.MIN : previousZoneOffsetTransition.getInstant();
                ZoneOffsetTransition zoneOffsetTransition = rules.nextTransition(tstamp);
                this.zoneTransitionStop = zoneOffsetTransition == null ? Instant.MAX : zoneOffsetTransition.getInstant();
            }
            int offsetSeconds = rules.getOffset(tstamp).getTotalSeconds();
            this.cachingEnabled = offsetSeconds % 60 == 0;
        }

        public boolean canFormat(Instant tstamp) {
            return tstamp.compareTo(this.zoneTransitionStart) >= 0 && tstamp.isBefore(this.zoneTransitionStop);
        }

        public String format(Instant tstamp) {
            if (!this.cachingEnabled) {
                return FastISOTimestampFormatter.this.buildFromFormatter(tstamp);
            }
            TimestampPeriod currentTimestampPeriod = this.cachedTimestampPeriod;
            if (currentTimestampPeriod != null && currentTimestampPeriod.canFormat(tstamp)) {
                return this.buildFromCache(currentTimestampPeriod, tstamp);
            }
            String formatted = FastISOTimestampFormatter.this.buildFromFormatter(tstamp);
            this.cachedTimestampPeriod = this.createNewCache(tstamp, formatted);
            return formatted;
        }

        private TimestampPeriod createNewCache(Instant tstamp, String formatted) {
            String prefix = formatted.substring(0, 17);
            String suffix = this.findSuffix(formatted, 17);
            Instant cacheStart = tstamp.truncatedTo(ChronoUnit.MINUTES);
            Instant cacheStop = cacheStart.plus(1L, ChronoUnit.MINUTES);
            return new TimestampPeriod(cacheStart, cacheStop, prefix, suffix);
        }

        private String findSuffix(String formatted, int beginIndex) {
            int pos;
            boolean dotFound = false;
            for (pos = beginIndex; pos < formatted.length(); ++pos) {
                char c = formatted.charAt(pos);
                if (c == '.') {
                    if (dotFound) break;
                    dotFound = true;
                    continue;
                }
                if (!Character.isDigit(c)) break;
            }
            if (pos < formatted.length()) {
                return formatted.substring(pos);
            }
            return "";
        }

        private String buildFromCache(TimestampPeriod cache, Instant tstamp) {
            return cache.format(tstamp);
        }
    }

    private class TimestampPeriod {
        private final Instant periodStart;
        private final Instant periodStop;
        private final String suffix;
        private final String prefix;

        TimestampPeriod(Instant periodStart, Instant periodStop, String prefix, String suffix) {
            this.periodStart = periodStart;
            this.periodStop = periodStop;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public boolean canFormat(Instant tstamp) {
            return tstamp.compareTo(this.periodStart) >= 0 && tstamp.isBefore(this.periodStop);
        }

        public String format(Instant tstamp) {
            StringBuilder sb = STRING_BUILDERS.get();
            sb.setLength(0);
            sb.append(this.prefix);
            int nanos = tstamp.getNano();
            int seconds = (int)(tstamp.getEpochSecond() - this.periodStart.getEpochSecond());
            if (seconds < 10) {
                sb.append('0');
            }
            sb.append(seconds);
            if (nanos > 0) {
                int dotPos = sb.length();
                sb.append('.');
                for (int i = 0; i < DECIMALS.length && nanos < DECIMALS[i]; ++i) {
                    sb.append('0');
                }
                sb.append(nanos);
                if (FastISOTimestampFormatter.this.trimMillis) {
                    while (sb.length() > dotPos && sb.charAt(sb.length() - 1) == '0') {
                        sb.setLength(sb.length() - 1);
                    }
                } else {
                    while (sb.length() > dotPos && sb.charAt(sb.length() - 1) == '0' && sb.charAt(sb.length() - 2) == '0' && sb.charAt(sb.length() - 3) == '0') {
                        sb.setLength(sb.length() - 3);
                    }
                }
            }
            sb.append(this.suffix);
            return sb.toString();
        }
    }
}

