/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.CloseUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.dataformat.DataFormatFactory;
import net.logstash.logback.dataformat.json.JsonDataFormatFactory;
import net.logstash.logback.decorate.CompositeJsonGeneratorDecorator;
import net.logstash.logback.decorate.CompositeMapperBuilderDecorator;
import net.logstash.logback.decorate.CompositeTokenStreamFactoryBuilderDecorator;
import net.logstash.logback.decorate.Decorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.decorate.MapperBuilderDecorator;
import net.logstash.logback.decorate.TokenStreamFactoryBuilderDecorator;
import net.logstash.logback.util.ProxyOutputStream;
import net.logstash.logback.util.ThreadLocalHolder;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TSFBuilder;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.MapperBuilder;

public abstract class AbstractCompositeJsonFormatter<Event extends DeferredProcessingAware>
extends ContextAwareBase
implements LifeCycle {
    private static final Map<String, String> DATA_FORMATS = Map.of("json", "net.logstash.logback.dataformat.json.JsonDataFormatFactory", "yaml", "net.logstash.logback.dataformat.yaml.YamlDataFormatFactory", "cbor", "net.logstash.logback.dataformat.cbor.CborDataFormatFactory", "smile", "net.logstash.logback.dataformat.smile.SmileDataFormatFactory");
    private DataFormatFactory dataFormatFactory = new JsonDataFormatFactory();
    private final CompositeMapperBuilderDecorator mapperBuilderDecorator = new CompositeMapperBuilderDecorator();
    private final CompositeTokenStreamFactoryBuilderDecorator tokenStreamFactoryBuilderDecorator = new CompositeTokenStreamFactoryBuilderDecorator();
    private final CompositeJsonGeneratorDecorator jsonGeneratorDecorator = new CompositeJsonGeneratorDecorator();
    private ObjectMapper objectMapper;
    private JsonProviders<Event> jsonProviders = new JsonProviders();
    private JsonEncoding encoding = JsonEncoding.UTF8;
    private boolean findAndRegisterJacksonModules = true;
    private volatile boolean started;
    private ThreadLocalHolder<JsonFormatter> threadLocalJsonFormatter;

    public AbstractCompositeJsonFormatter(ContextAware declaredOrigin) {
        super(declaredOrigin);
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.jsonProviders.getProviders().isEmpty()) {
            this.addError("No providers configured");
        }
        this.objectMapper = this.createObjectMapper();
        this.jsonProviders.setContext(this.context);
        this.jsonProviders.setObjectMapper(this.objectMapper);
        this.jsonProviders.start();
        this.threadLocalJsonFormatter = new ThreadLocalHolder<JsonFormatter>(this::createJsonFormatter);
        this.started = true;
    }

    public void stop() {
        if (this.isStarted()) {
            this.threadLocalJsonFormatter.close();
            this.jsonProviders.stop();
            this.objectMapper = null;
            this.started = false;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private ObjectMapper createObjectMapper() {
        TokenStreamFactory tokenStreamFactory = this.createTokenStreamFactory();
        MapperBuilder mapperBuilder = this.dataFormatFactory.createMapperBuilder(tokenStreamFactory).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS});
        if (this.findAndRegisterJacksonModules) {
            try {
                mapperBuilder = mapperBuilder.findAndAddModules();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                this.addError("Error occurred while dynamically loading jackson modules", serviceConfigurationError);
            }
        }
        mapperBuilder = this.mapperBuilderDecorator.decorate(mapperBuilder);
        return mapperBuilder.build();
    }

    private TokenStreamFactory createTokenStreamFactory() {
        return ((TSFBuilder)this.tokenStreamFactoryBuilderDecorator.decorate(this.dataFormatFactory.createTokenStreamFactoryBuilder())).disable(StreamWriteFeature.AUTO_CLOSE_TARGET).build();
    }

    public void writeEvent(Event event, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream);
        if (!this.isStarted()) {
            throw new IllegalStateException("Formatter is not started");
        }
        try (JsonFormatter formatter = this.threadLocalJsonFormatter.acquire();){
            formatter.writeEvent(outputStream, event);
        }
    }

    private JsonFormatter createJsonFormatter() {
        try {
            DisconnectedOutputStream outputStream = new DisconnectedOutputStream();
            JsonGenerator generator = this.createGenerator(outputStream);
            return new JsonFormatter(outputStream, generator);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to initialize Jackson JSON layer", e);
        }
    }

    protected void writeEventToGenerator(JsonGenerator generator, Event event) throws IOException {
        generator.writeStartObject();
        this.jsonProviders.writeTo(generator, event);
        generator.writeEndObject();
        generator.flush();
    }

    protected void prepareForDeferredProcessing(Event event) {
        event.prepareForDeferredProcessing();
        this.jsonProviders.prepareForDeferredProcessing(event);
    }

    private JsonGenerator createGenerator(OutputStream outputStream) throws IOException {
        return this.jsonGeneratorDecorator.decorate(this.objectMapper.createGenerator(outputStream, this.encoding));
    }

    public String getDataFormat() {
        return this.dataFormatFactory.getName();
    }

    public void setDataFormat(String dataFormat) {
        String dataFormatClassName = DATA_FORMATS.get(dataFormat);
        if (dataFormatClassName == null) {
            throw new IllegalArgumentException(String.format("Unknown data format: %s.  Known data formats are: %s", dataFormat, String.join((CharSequence)",", DATA_FORMATS.keySet())));
        }
        try {
            this.setDataFormatFactory((DataFormatFactory)Class.forName(dataFormatClassName).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Unable to instantiate %s. Ensure the appropriate jackson dataformat module is on the classpath.", dataFormatClassName), e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Unable to instantiate %s.", dataFormatClassName), e);
        }
    }

    public DataFormatFactory getDataFormatFactory() {
        return this.dataFormatFactory;
    }

    public void setDataFormatFactory(DataFormatFactory dataFormatFactory) {
        this.dataFormatFactory = Objects.requireNonNull(dataFormatFactory);
    }

    public void addDecorator(Decorator<?> decorator) {
        Objects.requireNonNull(decorator);
        if (decorator instanceof MapperBuilderDecorator) {
            MapperBuilderDecorator mapperBuilderDecoratorToAdd = (MapperBuilderDecorator)decorator;
            this.addMapperBuilderDecorator(mapperBuilderDecoratorToAdd);
        } else if (decorator instanceof TokenStreamFactoryBuilderDecorator) {
            TokenStreamFactoryBuilderDecorator tokenStreamFactoryBuilderDecoratorToAdd = (TokenStreamFactoryBuilderDecorator)decorator;
            this.addTokenStreamFactoryBuilderDecorator(tokenStreamFactoryBuilderDecoratorToAdd);
        } else if (decorator instanceof JsonGeneratorDecorator) {
            JsonGeneratorDecorator jsonGeneratorDecoratorToAdd = (JsonGeneratorDecorator)decorator;
            this.addJsonGeneratorDecorator(jsonGeneratorDecoratorToAdd);
        } else {
            throw new IllegalArgumentException("Unknown decorator type:" + decorator.getClass().getName());
        }
    }

    public void addJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecoratorToAdd) {
        this.jsonGeneratorDecorator.addDecorator(jsonGeneratorDecoratorToAdd);
    }

    public void addTokenStreamFactoryBuilderDecorator(TokenStreamFactoryBuilderDecorator tokenStreamFactoryBuilderDecoratorToAdd) {
        this.tokenStreamFactoryBuilderDecorator.addDecorator(tokenStreamFactoryBuilderDecoratorToAdd);
    }

    public void addMapperBuilderDecorator(MapperBuilderDecorator mapperBuilderDecoratorToAdd) {
        this.mapperBuilderDecorator.addDecorator(mapperBuilderDecoratorToAdd);
    }

    public CompositeTokenStreamFactoryBuilderDecorator getTokenStreamFactoryBuilderDecorator() {
        return this.tokenStreamFactoryBuilderDecorator;
    }

    public CompositeMapperBuilderDecorator getMapperBuilderDecorator() {
        return this.mapperBuilderDecorator;
    }

    public CompositeJsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.jsonGeneratorDecorator;
    }

    public JsonProviders<Event> getProviders() {
        return this.jsonProviders;
    }

    public String getEncoding() {
        return this.encoding.getJavaName();
    }

    public void setEncoding(String encodingName) {
        for (JsonEncoding encoding : JsonEncoding.values()) {
            if (!encoding.getJavaName().equalsIgnoreCase(encodingName) && !encoding.name().equalsIgnoreCase(encodingName)) continue;
            this.encoding = encoding;
            return;
        }
        throw new IllegalArgumentException("Unknown encoding " + encodingName);
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.jsonProviders = Objects.requireNonNull(jsonProviders);
    }

    public boolean isFindAndRegisterJacksonModules() {
        return this.findAndRegisterJacksonModules;
    }

    public void setFindAndRegisterJacksonModules(boolean findAndRegisterJacksonModules) {
        this.findAndRegisterJacksonModules = findAndRegisterJacksonModules;
    }

    private class JsonFormatter
    implements ThreadLocalHolder.Lifecycle,
    Closeable {
        private final JsonGenerator generator;
        private final DisconnectedOutputStream stream;
        private boolean recyclable = true;

        JsonFormatter(DisconnectedOutputStream outputStream, JsonGenerator generator) {
            this.stream = Objects.requireNonNull(outputStream);
            this.generator = Objects.requireNonNull(generator);
        }

        public void writeEvent(OutputStream outputStream, Event event) throws IOException {
            try {
                this.stream.connect(outputStream);
                AbstractCompositeJsonFormatter.this.writeEventToGenerator(this.generator, event);
            }
            catch (IOException | RuntimeException e) {
                this.recyclable = false;
                throw e;
            }
            finally {
                this.stream.disconnect();
            }
        }

        @Override
        public boolean recycle() {
            return this.recyclable;
        }

        @Override
        public void dispose() {
            CloseUtil.closeQuietly((Closeable)this.generator);
        }

        @Override
        public void close() {
            AbstractCompositeJsonFormatter.this.threadLocalJsonFormatter.release();
        }
    }

    private static class DisconnectedOutputStream
    extends ProxyOutputStream {
        DisconnectedOutputStream() {
            super(null);
        }

        public void connect(OutputStream out) {
            this.delegate = out;
        }

        public void disconnect() {
            this.delegate = null;
        }
    }
}

