/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.argument;

import java.util.Objects;
import java.util.function.Supplier;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.marker.EmptyLogstashMarker;
import tools.jackson.core.JsonGenerator;

public class DeferredStructuredArgument
implements StructuredArgument {
    private final Supplier<? extends StructuredArgument> structureArgumentSupplier;
    private volatile StructuredArgument suppliedValue;

    public DeferredStructuredArgument(Supplier<? extends StructuredArgument> structureArgumentSupplier) {
        this.structureArgumentSupplier = Objects.requireNonNull(structureArgumentSupplier, "structureArgumentSupplier must not be null");
    }

    @Override
    public void writeTo(JsonGenerator generator) {
        this.getSuppliedValue().writeTo(generator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructuredArgument getSuppliedValue() {
        if (this.suppliedValue == null) {
            DeferredStructuredArgument deferredStructuredArgument = this;
            synchronized (deferredStructuredArgument) {
                if (this.suppliedValue == null) {
                    StructuredArgument structuredArgument = this.structureArgumentSupplier.get();
                    if (structuredArgument == null) {
                        structuredArgument = new EmptyLogstashMarker();
                    }
                    this.suppliedValue = structuredArgument;
                }
            }
        }
        return this.suppliedValue;
    }
}

