/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.security.AccessController;
import java.security.Provider;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.ProviderService;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServiceKeyStore;
import net.jsign.jca.SigningServiceSignature;

public class SigningServiceJcaProvider
extends Provider {
    public SigningServiceJcaProvider(SigningService service) {
        super(service.getName(), 1.0, service.getName() + " signing service provider");
        AccessController.doPrivileged(() -> {
            this.putService(new ProviderService(this, "KeyStore", service.getName().toUpperCase(), SigningServiceKeyStore.class.getName(), () -> new SigningServiceKeyStore(service)));
            for (String alg : new String[]{"RSA", "ECDSA"}) {
                for (DigestAlgorithm digest : DigestAlgorithm.values()) {
                    if (digest == DigestAlgorithm.MD5) continue;
                    String algorithm = digest.name() + "with" + alg;
                    this.putService(new ProviderService(this, "Signature", algorithm, SigningServiceSignature.class.getName(), () -> new SigningServiceSignature(algorithm)));
                }
            }
            return null;
        });
    }
}

