/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.JsonWriter;
import net.jsign.jca.RESTClient;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;

public class AzureTrustedSigningService
implements SigningService {
    private final Map<String, Certificate[]> certificates = new HashMap<String, Certificate[]>();
    private final RESTClient client;
    private long timeout = 60L;
    private final Map<String, String> algorithmMapping = new HashMap<String, String>();

    public AzureTrustedSigningService(String endpoint, String token) {
        this.algorithmMapping.put("SHA256withRSA", "RS256");
        this.algorithmMapping.put("SHA384withRSA", "RS384");
        this.algorithmMapping.put("SHA512withRSA", "RS512");
        this.algorithmMapping.put("SHA256withECDSA", "ES256");
        this.algorithmMapping.put("SHA384withECDSA", "ES384");
        this.algorithmMapping.put("SHA512withECDSA", "ES512");
        this.algorithmMapping.put("SHA256withRSA/PSS", "PS256");
        this.algorithmMapping.put("SHA384withRSA/PSS", "PS384");
        this.algorithmMapping.put("SHA512withRSA/PSS", "PS512");
        if (!endpoint.startsWith("http")) {
            endpoint = "https://" + endpoint;
        }
        this.client = new RESTClient(endpoint).authentication(conn -> conn.setRequestProperty("Authorization", "Bearer " + token)).errorHandler(response -> {
            if (response.containsKey("errorDetail")) {
                Map error = (Map)response.get("errorDetail");
                return error.get("code") + " - " + error.get("message");
            }
            String errors = JsonWriter.format(response.get("errors"));
            return response.get("status") + " - " + response.get("title") + ": " + errors;
        });
    }

    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public String getName() {
        return "TrustedSigning";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        return Collections.emptyList();
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        if (!this.certificates.containsKey(alias)) {
            try {
                String account = alias.substring(0, alias.indexOf(47));
                String profile = alias.substring(alias.indexOf(47) + 1);
                SignStatus status = this.sign(account, profile, "RS256", new byte[32]);
                this.certificates.put(alias, status.getCertificateChain().toArray(new Certificate[0]));
            }
            catch (Exception e) {
                throw new KeyStoreException("Unable to retrieve the certificate chain '" + alias + "'", e);
            }
        }
        return this.certificates.get(alias);
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        return new SigningServicePrivateKey(alias, "RSA", this);
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        String alg = this.algorithmMapping.get(algorithm);
        if (alg == null) {
            throw new InvalidAlgorithmParameterException("Unsupported signing algorithm: " + algorithm);
        }
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        data = digestAlgorithm.getMessageDigest().digest(data);
        String alias = privateKey.getId();
        String account = alias.substring(0, alias.indexOf(47));
        String profile = alias.substring(alias.indexOf(47) + 1);
        try {
            SignStatus status = this.sign(account, profile, alg, data);
            return status.signature;
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private SignStatus sign(String account, String profile, String algorithm, byte[] data) throws IOException {
        Object status;
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("signatureAlgorithm", algorithm);
        request.put("digest", Base64.getEncoder().encodeToString(data));
        Map<String, ?> response = this.client.post("/codesigningaccounts/" + account + "/certificateprofiles/" + profile + "/sign?api-version=2022-06-15-preview", JsonWriter.format(request));
        String operationId = (String)response.get("operationId");
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (System.currentTimeMillis() - startTime < this.timeout * 1000L) {
            try {
                Thread.sleep(Math.min(1000, 50 + 10 * i++));
            }
            catch (InterruptedException e) {
                break;
            }
            response = this.client.get("/codesigningaccounts/" + account + "/certificateprofiles/" + profile + "/sign/" + operationId + "?api-version=2022-06-15-preview");
            status = (String)response.get("status");
            if ("InProgress".equals(status)) continue;
            if ("Succeeded".equals(status)) break;
            throw new IOException("Signing operation " + operationId + " failed: " + (String)status);
        }
        if (!"Succeeded".equals(response.get("status"))) {
            throw new IOException("Signing operation " + operationId + " timed out");
        }
        status = new SignStatus();
        ((SignStatus)status).signature = Base64.getDecoder().decode((String)response.get("signature"));
        ((SignStatus)status).signingCertificate = new String(Base64.getDecoder().decode((String)response.get("signingCertificate")));
        return status;
    }

    private static class SignStatus {
        public byte[] signature;
        public String signingCertificate;

        private SignStatus() {
        }

        public Collection<? extends Certificate> getCertificateChain() throws CertificateException {
            byte[] cerbin = Base64.getMimeDecoder().decode(this.signingCertificate);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return certificateFactory.generateCertificates(new ByteArrayInputStream(cerbin));
        }
    }
}

