/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.jsign.jca.AmazonCredentials;

class AmazonECSCredentialsClient {
    private static final URL DEFAULT_AWS_CONTAINER_SERVICE_ENDPOINT;
    private final URL endpoint;

    AmazonECSCredentialsClient() throws UnknownServiceException {
        this(AmazonECSCredentialsClient.defaultCredentialsUrl());
    }

    AmazonECSCredentialsClient(URL endpoint) {
        if (endpoint == null || !"http".equals(endpoint.getProtocol()) && !"https".equals(endpoint.getProtocol())) {
            throw new IllegalArgumentException("Null endpoint or unexpected protocol for AWS container credential metadata endpoint: " + endpoint);
        }
        this.endpoint = endpoint;
    }

    public AmazonCredentials getCredentials() throws IOException {
        int responseCode;
        String authTokenFile;
        HttpURLConnection connection = (HttpURLConnection)this.endpoint.openConnection();
        connection.setConnectTimeout(3000);
        connection.setReadTimeout(3000);
        String authToken = System.getenv("AWS_CONTAINER_AUTHORIZATION_TOKEN");
        if (authToken == null && (authTokenFile = System.getenv("AWS_CONTAINER_AUTHORIZATION_TOKEN_FILE")) != null) {
            authToken = new String(Files.readAllBytes(Paths.get(authTokenFile, new String[0])), StandardCharsets.UTF_8);
        }
        if (authToken != null) {
            connection.addRequestProperty("Authorization", authToken);
        }
        if ((responseCode = connection.getResponseCode()) != 200) {
            String responseMessage = connection.getResponseMessage();
            throw new IOException(String.format("Unexpected HTTP response code fetching AWS container credentials: %d (%s)", responseCode, responseMessage == null ? "No message" : responseMessage));
        }
        try {
            Map json = JsonReader.jsonToMaps((InputStream)connection.getInputStream(), new HashMap());
            return new AmazonCredentials((String)json.get("AccessKeyId"), (String)json.get("SecretAccessKey"), (String)json.get("Token"));
        }
        catch (JsonIoException e) {
            throw new IOException("Error parsing JSON response from AWS container credentials endpoint", e);
        }
    }

    private static URL defaultCredentialsUrl() throws UnknownServiceException {
        URL endpoint;
        String relativeUri = System.getenv("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI");
        if (relativeUri != null) {
            try {
                endpoint = new URL(DEFAULT_AWS_CONTAINER_SERVICE_ENDPOINT, relativeUri);
            }
            catch (MalformedURLException e) {
                throw new UnknownServiceException("Invalid relative URI for AWS container credential metadata endpoint: " + relativeUri);
            }
        } else {
            String fullUri = System.getenv("AWS_CONTAINER_CREDENTIALS_FULL_URI");
            if (fullUri != null) {
                try {
                    endpoint = new URL(fullUri);
                }
                catch (MalformedURLException e) {
                    throw new UnknownServiceException("Invalid full URI for AWS container credential metadata endpoint: " + fullUri);
                }
            } else {
                throw new UnknownServiceException("No AWS container credential metadata endpoint URIs available");
            }
        }
        return endpoint;
    }

    static {
        try {
            DEFAULT_AWS_CONTAINER_SERVICE_ENDPOINT = new URL("http://169.254.170.2");
        }
        catch (MalformedURLException e) {
            throw new AssertionError("Invalid default URI for AWS container credential metadata endpoint", e);
        }
    }
}

