/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import net.jsign.jca.AmazonECSCredentialsClient;
import net.jsign.jca.AmazonIMDS2Client;

public class AmazonCredentials {
    private final String accessKey;
    private final String secretKey;
    private final String sessionToken;

    public AmazonCredentials(String accessKey, String secretKey, String sessionToken) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.sessionToken = sessionToken;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public static AmazonCredentials parse(String credentials) throws IllegalArgumentException {
        String[] elements = credentials.split("\\|", 3);
        if (elements.length < 2) {
            throw new IllegalArgumentException("Invalid AWS credentials: " + credentials);
        }
        String accessKey = elements[0];
        String secretKey = elements[1];
        String sessionToken = elements.length > 2 ? elements[2] : null;
        return new AmazonCredentials(accessKey, secretKey, sessionToken);
    }

    public static AmazonCredentials getDefault() throws IOException {
        if (AmazonCredentials.getenv("AWS_ACCESS_KEY_ID") != null || AmazonCredentials.getenv("AWS_ACCESS_KEY") != null) {
            String secretKey;
            String accessKey = AmazonCredentials.getenv("AWS_ACCESS_KEY_ID");
            if (accessKey == null) {
                accessKey = AmazonCredentials.getenv("AWS_ACCESS_KEY");
            }
            if ((secretKey = AmazonCredentials.getenv("AWS_SECRET_KEY")) == null) {
                secretKey = AmazonCredentials.getenv("AWS_SECRET_ACCESS_KEY");
            }
            String sessionToken = AmazonCredentials.getenv("AWS_SESSION_TOKEN");
            return new AmazonCredentials(accessKey, secretKey, sessionToken);
        }
        try {
            return new AmazonECSCredentialsClient().getCredentials();
        }
        catch (IOException ecsException) {
            try {
                return new AmazonIMDS2Client().getCredentials();
            }
            catch (IOException imds2Exception) {
                ecsException.addSuppressed(imds2Exception);
                throw ecsException;
            }
        }
    }

    static String getenv(String name) {
        return System.getenv(name);
    }
}

