/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.ProviderException;
import java.util.ArrayList;
import net.jsign.PKCS11Configuration;
import net.jsign.ProviderUtils;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

class SafeNetEToken {
    SafeNetEToken() {
    }

    static Provider getProvider(String name) {
        return ProviderUtils.createSunPKCS11Provider(SafeNetEToken.getSunPKCS11Configuration(name));
    }

    static String getSunPKCS11Configuration(String name) {
        long slot;
        File library = SafeNetEToken.getPKCS11Library();
        if (!library.exists()) {
            throw new ProviderException("SafeNet eToken PKCS11 module is not installed (" + library + " is missing)");
        }
        try {
            try {
                slot = Integer.parseInt(name);
            }
            catch (Exception e) {
                slot = SafeNetEToken.getTokenSlot(library);
            }
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return new PKCS11Configuration().name("SafeNet eToken").library(library).slot(slot).toString();
    }

    static long getTokenSlot(File libraryPath) throws PKCS11Exception, IOException {
        PKCS11 pkcs11 = PKCS11.getInstance(libraryPath.getAbsolutePath(), "C_GetFunctionList", null, false);
        long[] slots = pkcs11.C_GetSlotList(true);
        return slots.length > 0 ? slots[0] : -1L;
    }

    static File getPKCS11Library() {
        String osname = System.getProperty("os.name");
        String arch = System.getProperty("sun.arch.data.model");
        if (osname.contains("Windows")) {
            return new File(System.getenv("windir") + "/system32/eTPKCS11.dll");
        }
        if (osname.contains("Mac")) {
            return new File("/usr/local/lib/libeTPkcs11.dylib");
        }
        ArrayList<String> paths = new ArrayList<String>();
        if ("64".equals(arch)) {
            paths.add("/usr/lib64/pkcs11/libeTPkcs11.so");
            paths.add("/usr/lib64/libeTPkcs11.so");
            paths.add("/usr/lib64/libeToken.so");
        }
        paths.add("/usr/lib/pkcs11/libeTPkcs11.so");
        paths.add("/usr/lib/pkcs11/libeToken.so");
        paths.add("/usr/lib/libeTPkcs11.so");
        paths.add("/usr/lib/libeToken.so");
        String libraryPath = System.getenv("LD_LIBRARY_PATH");
        if (libraryPath != null) {
            for (String s : libraryPath.split(":")) {
                paths.add(s + "/libeToken.so");
                paths.add(s + "/libeTPkcs11.so");
            }
        }
        for (String path : paths) {
            File library = new File(path);
            if (!library.exists()) continue;
            return library;
        }
        return new File("/usr/local/lib/libeToken.so");
    }
}

