/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.UnknownServiceException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import javax.smartcardio.CardException;
import net.jsign.CertificateUtils;
import net.jsign.KeyStoreBuilder;
import net.jsign.OpenSC;
import net.jsign.PrivateKeyUtils;
import net.jsign.ProviderUtils;
import net.jsign.SafeNetEToken;
import net.jsign.YubiKey;
import net.jsign.jca.AmazonCredentials;
import net.jsign.jca.AmazonSigningService;
import net.jsign.jca.AzureKeyVaultSigningService;
import net.jsign.jca.AzureTrustedSigningService;
import net.jsign.jca.CryptoCertumCardSigningService;
import net.jsign.jca.DigiCertOneSigningService;
import net.jsign.jca.ESignerSigningService;
import net.jsign.jca.GaraSignCredentials;
import net.jsign.jca.GaraSignSigningService;
import net.jsign.jca.GoogleCloudSigningService;
import net.jsign.jca.HashiCorpVaultSigningService;
import net.jsign.jca.OpenPGPCardSigningService;
import net.jsign.jca.OracleCloudCredentials;
import net.jsign.jca.OracleCloudSigningService;
import net.jsign.jca.PIVCardSigningService;
import net.jsign.jca.SignPathSigningService;
import net.jsign.jca.SignServerCredentials;
import net.jsign.jca.SignServerSigningService;
import net.jsign.jca.SigningServiceJcaProvider;

public enum KeyStoreType {
    NONE(true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keyfile() == null) {
                throw new IllegalArgumentException("keyfile " + params.parameterName() + " must be set");
            }
            if (!params.keyfile().exists()) {
                throw new IllegalArgumentException("The keyfile " + params.keyfile() + " couldn't be found");
            }
            if (params.certfile() == null) {
                throw new IllegalArgumentException("certfile " + params.parameterName() + " must be set");
            }
            if (!params.certfile().exists()) {
                throw new IllegalArgumentException("The certfile " + params.certfile() + " couldn't be found");
            }
        }

        @Override
        KeyStore getKeystore(KeyStoreBuilder params, Provider provider) throws KeyStoreException {
            PrivateKey privateKey;
            Certificate[] chain;
            try {
                chain = CertificateUtils.loadCertificateChain(params.certfile());
            }
            catch (Exception e) {
                throw new KeyStoreException("Failed to load the certificate from " + params.certfile(), e);
            }
            try {
                privateKey = PrivateKeyUtils.load(params.keyfile(), params.keypass() != null ? params.keypass() : params.storepass());
            }
            catch (Exception e) {
                throw new KeyStoreException("Failed to load the private key from " + params.keyfile(), e);
            }
            KeyStore ks = KeyStore.getInstance("JKS");
            try {
                ks.load(null, null);
                String keypass = params.keypass();
                ks.setKeyEntry("jsign", privateKey, keypass != null ? keypass.toCharArray() : new char[]{}, chain);
            }
            catch (Exception e) {
                throw new KeyStoreException(e);
            }
            return ks;
        }
    }
    ,
    JKS(true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must be set");
            }
            if (!params.createFile(params.keystore()).exists()) {
                throw new IllegalArgumentException("The keystore " + params.keystore() + " couldn't be found");
            }
            if (params.keypass() == null && params.storepass() != null) {
                params.keypass(params.storepass());
            }
        }
    }
    ,
    JCEKS(true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must be set");
            }
            if (!params.createFile(params.keystore()).exists()) {
                throw new IllegalArgumentException("The keystore " + params.keystore() + " couldn't be found");
            }
            if (params.keypass() == null && params.storepass() != null) {
                params.keypass(params.storepass());
            }
        }
    }
    ,
    PKCS12(true, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must be set");
            }
            if (!params.createFile(params.keystore()).exists()) {
                throw new IllegalArgumentException("The keystore " + params.keystore() + " couldn't be found");
            }
            if (params.keypass() == null && params.storepass() != null) {
                params.keypass(params.storepass());
            }
        }
    }
    ,
    PKCS11(false, true){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must be set");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            if (params.createFile(params.keystore()).exists()) {
                return ProviderUtils.createSunPKCS11Provider(params.keystore());
            }
            if (params.keystore().startsWith("SunPKCS11-")) {
                Provider provider = Security.getProvider(params.keystore());
                if (provider == null) {
                    throw new IllegalArgumentException("Security provider " + params.keystore() + " not found");
                }
                return provider;
            }
            throw new IllegalArgumentException("keystore " + params.parameterName() + " should either refer to the SunPKCS11 configuration file or to the name of the provider configured in jre/lib/security/java.security");
        }
    }
    ,
    OPENPGP(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the PIN");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            try {
                return new SigningServiceJcaProvider(new OpenPGPCardSigningService(params.keystore(), params.storepass(), params.certfile() != null ? KeyStoreType.getCertificateStore(params) : null));
            }
            catch (CardException e) {
                throw new IllegalStateException("Failed to initialize the OpenPGP card", e);
            }
        }
    }
    ,
    OPENSC(false, true){

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return OpenSC.getProvider(params.keystore());
        }
    }
    ,
    PIV(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the PIN");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            try {
                return new SigningServiceJcaProvider(new PIVCardSigningService(params.keystore(), params.storepass(), params.certfile() != null ? KeyStoreType.getCertificateStore(params) : null));
            }
            catch (CardException e) {
                throw new IllegalStateException("Failed to initialize the PIV card", e);
            }
        }
    }
    ,
    NITROKEY(false, true){

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return OpenSC.getProvider(params.keystore() != null ? params.keystore() : "Nitrokey");
        }
    }
    ,
    YUBIKEY(false, true){

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return YubiKey.getProvider();
        }

        @Override
        Set<String> getAliases(KeyStore keystore) throws KeyStoreException {
            Set<String> aliases = super.getAliases(keystore);
            aliases.remove("X.509 Certificate for PIV Attestation");
            return aliases;
        }
    }
    ,
    AWS(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the AWS region");
            }
            if (params.certfile() == null) {
                throw new IllegalArgumentException("certfile " + params.parameterName() + " must be set");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            AmazonCredentials credentials;
            if (params.storepass() != null) {
                credentials = AmazonCredentials.parse(params.storepass());
            } else {
                try {
                    credentials = AmazonCredentials.getDefault();
                }
                catch (UnknownServiceException e) {
                    throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the AWS credentials: <accessKey>|<secretKey>[|<sessionToken>], when not running from ECS or an EC2 instance", e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed fetching temporary credentials from ECS and IMDSv2 services", e);
                }
            }
            return new SigningServiceJcaProvider(new AmazonSigningService(params.keystore(), credentials, (Function<String, Certificate[]>)KeyStoreType.getCertificateStore(params)));
        }
    }
    ,
    AZUREKEYVAULT(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the Azure vault name");
            }
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the Azure API access token");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return new SigningServiceJcaProvider(new AzureKeyVaultSigningService(params.keystore(), params.storepass()));
        }
    }
    ,
    DIGICERTONE(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.storepass() == null || params.storepass().split("\\|").length != 3) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the DigiCert ONE API key and the client certificate: <apikey>|<keystore>|<password>");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            String[] elements = params.storepass().split("\\|");
            return new SigningServiceJcaProvider(new DigiCertOneSigningService(params.keystore(), elements[0], params.createFile(elements[1]), elements[2]));
        }
    }
    ,
    ESIGNER(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.storepass() == null || !params.storepass().contains("|")) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the SSL.com username and password: <username>|<password>");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            String[] elements = params.storepass().split("\\|", 2);
            String endpoint = params.keystore() != null ? params.keystore() : "https://cs.ssl.com";
            try {
                return new SigningServiceJcaProvider(new ESignerSigningService(endpoint, elements[0], elements[1]));
            }
            catch (IOException e) {
                throw new IllegalStateException("Authentication failed with SSL.com", e);
            }
        }
    }
    ,
    GOOGLECLOUD(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the Google Cloud keyring");
            }
            if (!params.keystore().matches("projects/[^/]+/locations/[^/]+/keyRings/[^/]+")) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the path of the keyring (projects/{projectName}/locations/{location}/keyRings/{keyringName})");
            }
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the Google Cloud API access token");
            }
            if (params.certfile() == null) {
                throw new IllegalArgumentException("certfile " + params.parameterName() + " must be set");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return new SigningServiceJcaProvider(new GoogleCloudSigningService(params.keystore(), params.storepass(), KeyStoreType.getCertificateStore(params)));
        }
    }
    ,
    HASHICORPVAULT(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the HashiCorp Vault secrets engine URL");
            }
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the HashiCorp Vault token");
            }
            if (params.certfile() == null) {
                throw new IllegalArgumentException("certfile " + params.parameterName() + " must be set");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return new SigningServiceJcaProvider(new HashiCorpVaultSigningService(params.keystore(), params.storepass(), KeyStoreType.getCertificateStore(params)));
        }
    }
    ,
    ETOKEN(false, true){

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return SafeNetEToken.getProvider(params.keystore());
        }
    }
    ,
    ORACLECLOUD(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.certfile() == null) {
                throw new IllegalArgumentException("certfile " + params.parameterName() + " must be set");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            OracleCloudCredentials credentials = new OracleCloudCredentials();
            try {
                File config = null;
                String profile = null;
                if (params.storepass() != null) {
                    String[] elements = params.storepass().split("\\|", 2);
                    config = new File(elements[0]);
                    if (elements.length > 1) {
                        profile = elements[1];
                    }
                }
                credentials.load(config, profile);
                credentials.loadFromEnvironment();
                if (params.keypass() != null) {
                    credentials.setPassphrase(params.keypass());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("An error occurred while fetching the Oracle Cloud credentials", e);
            }
            return new SigningServiceJcaProvider(new OracleCloudSigningService(credentials, KeyStoreType.getCertificateStore(params)));
        }
    }
    ,
    TRUSTEDSIGNING(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the Azure endpoint (<region>.codesigning.azure.net)");
            }
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the Azure API access token");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return new SigningServiceJcaProvider(new AzureTrustedSigningService(params.keystore(), params.storepass()));
        }
    }
    ,
    GARASIGN(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.storepass() == null || params.storepass().split("\\|").length > 3) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the GaraSign username/password and/or the path to the keystore containing the TLS client certificate: <username>|<password>, <certificate>, or <username>|<password>|<certificate>");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            String[] elements = params.storepass().split("\\|");
            String username = null;
            String password = null;
            String certificate = null;
            if (elements.length == 1) {
                certificate = elements[0];
            } else if (elements.length == 2) {
                username = elements[0];
                password = elements[1];
            } else if (elements.length == 3) {
                username = elements[0];
                password = elements[1];
                certificate = elements[2];
            }
            GaraSignCredentials credentials = new GaraSignCredentials(username, password, certificate, params.keypass());
            return new SigningServiceJcaProvider(new GaraSignSigningService(params.keystore(), credentials));
        }
    }
    ,
    SIGNSERVER(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the SignServer API endpoint (e.g. https://example.com/signserver/)");
            }
            if (params.storepass() != null && params.storepass().split("\\|").length > 2) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the SignServer username/password or the path to the keystore containing the TLS client certificate: <username>|<password> or <certificate>");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            String username = null;
            String password = null;
            String certificate = null;
            if (params.storepass() != null) {
                String[] elements = params.storepass().split("\\|");
                if (elements.length == 1) {
                    certificate = elements[0];
                } else if (elements.length == 2) {
                    username = elements[0];
                    password = elements[1];
                }
            }
            SignServerCredentials credentials = new SignServerCredentials(username, password, certificate, params.keypass());
            return new SigningServiceJcaProvider(new SignServerSigningService(params.keystore(), credentials));
        }
    }
    ,
    SIGNPATH(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.keystore() == null) {
                throw new IllegalArgumentException("keystore " + params.parameterName() + " must specify the SignPath organization id (e.g. eacd4b78-6038-4450-9eec-4acd1c7ba6f1)");
            }
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the SignPath API access token");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            return new SigningServiceJcaProvider(new SignPathSigningService(params.keystore(), params.storepass()));
        }
    }
    ,
    CRYPTOCERTUM(false, false){

        @Override
        void validate(KeyStoreBuilder params) {
            if (params.storepass() == null) {
                throw new IllegalArgumentException("storepass " + params.parameterName() + " must specify the PIN");
            }
        }

        @Override
        Provider getProvider(KeyStoreBuilder params) {
            try {
                return new SigningServiceJcaProvider(new CryptoCertumCardSigningService(params.storepass()));
            }
            catch (CardException e) {
                throw new IllegalStateException("Failed to initialize the CryptoCertum card", e);
            }
        }
    };

    private final boolean fileBased;
    private final boolean pkcs11;

    private KeyStoreType(boolean fileBased, boolean pkcs11) {
        this.fileBased = fileBased;
        this.pkcs11 = pkcs11;
    }

    void validate(KeyStoreBuilder params) throws IllegalArgumentException {
    }

    Provider getProvider(KeyStoreBuilder params) {
        return null;
    }

    KeyStore getKeystore(KeyStoreBuilder params, Provider provider) throws KeyStoreException {
        KeyStore ks;
        try {
            KeyStoreType storetype;
            KeyStoreType keyStoreType = storetype = this.pkcs11 ? PKCS11 : this;
            ks = provider != null ? KeyStore.getInstance(storetype.name(), provider) : KeyStore.getInstance(storetype.name());
        }
        catch (KeyStoreException e) {
            throw new KeyStoreException("keystore type '" + this.name() + "' is not supported" + (provider != null ? " with security provider " + provider.getName() : ""), e);
        }
        try (FileInputStream in = this.fileBased ? new FileInputStream(params.createFile(params.keystore())) : null;){
            ks.load(in, params.storepass() != null ? params.storepass().toCharArray() : null);
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to load the " + this.name() + " keystore" + (params.keystore() != null ? " " + params.keystore() : ""), e);
        }
        return ks;
    }

    Set<String> getAliases(KeyStore keystore) throws KeyStoreException {
        return new LinkedHashSet<String>(Collections.list(keystore.aliases()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static KeyStoreType of(File path) {
        String filename;
        if (path.exists()) {
            try (FileInputStream in = new FileInputStream(path);){
                byte[] header = new byte[4];
                in.read(header);
                ByteBuffer buffer = ByteBuffer.wrap(header);
                if (buffer.get(0) == 48) {
                    KeyStoreType keyStoreType = PKCS12;
                    return keyStoreType;
                }
                if (((long)buffer.getInt(0) & 0xFFFFFFFFL) == 0xCECECECEL) {
                    KeyStoreType keyStoreType = JCEKS;
                    return keyStoreType;
                }
                if (((long)buffer.getInt(0) & 0xFFFFFFFFL) == 0xFEEDFEEDL) {
                    KeyStoreType keyStoreType = JKS;
                    return keyStoreType;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load the keystore " + path, e);
            }
        }
        if ((filename = path.getName().toLowerCase()).endsWith(".p12")) return PKCS12;
        if (filename.endsWith(".pfx")) {
            return PKCS12;
        }
        if (filename.endsWith(".jceks")) {
            return JCEKS;
        }
        if (!filename.endsWith(".jks")) return null;
        return JKS;
    }

    private static Function<String, Certificate[]> getCertificateStore(KeyStoreBuilder params) {
        return alias -> {
            if (alias == null || alias.isEmpty()) {
                return null;
            }
            try {
                return CertificateUtils.loadCertificateChain(params.certfile());
            }
            catch (IOException | CertificateException e) {
                throw new RuntimeException("Failed to load the certificate from " + params.certfile(), e);
            }
        };
    }
}

