/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import net.jsign.HttpClient;
import net.jsign.OSUtils;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

class CertificateUtils {
    private CertificateUtils() {
    }

    public static Certificate[] loadCertificateChain(File file) throws IOException, CertificateException {
        try (FileInputStream in = new FileInputStream(file);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(in);
            ArrayList<? extends Certificate> list = new ArrayList<Certificate>(certificates);
            list.sort(CertificateUtils.getChainComparator());
            Certificate[] certificateArray = list.toArray(new Certificate[0]);
            return certificateArray;
        }
    }

    public static Comparator<X509Certificate> getChainComparator() {
        return Comparator.comparing(X509Certificate::getBasicConstraints).thenComparing(X509Certificate::getNotBefore, Comparator.reverseOrder()).thenComparing(X509Certificate::getSubjectX500Principal, Comparator.comparing(X500Principal::getName));
    }

    public static AuthorityInformationAccess getAuthorityInformationAccess(X509Certificate certificate) {
        byte[] aia = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        return aia != null ? AuthorityInformationAccess.getInstance((Object)ASN1OctetString.getInstance((Object)aia).getOctets()) : null;
    }

    public static String getIssuerCertificateURL(X509Certificate certificate) {
        AuthorityInformationAccess aia = CertificateUtils.getAuthorityInformationAccess(certificate);
        if (aia != null) {
            for (AccessDescription access : aia.getAccessDescriptions()) {
                if (!X509ObjectIdentifiers.id_ad_caIssuers.equals((ASN1Primitive)access.getAccessMethod())) continue;
                return access.getAccessLocation().getName().toString();
            }
        }
        return null;
    }

    public static Collection<X509Certificate> getIssuerCertificates(X509Certificate certificate) throws IOException, CertificateException {
        String certificateURL = CertificateUtils.getIssuerCertificateURL(certificate);
        if (certificateURL != null) {
            File cacheDirectory = new File(OSUtils.getCacheDirectory("jsign"), "certificates");
            HttpClient cache = new HttpClient(cacheDirectory, 7776000000L);
            try (InputStream in = cache.getInputStream(new URL(certificateURL));){
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> collection = certificateFactory.generateCertificates(in);
                return collection;
            }
        }
        return Collections.emptyList();
    }

    public static Collection<X509Certificate> getCertificateChain(X509Certificate certificate, int maxDepth) {
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        chain.add(certificate);
        if (maxDepth > 0 && !CertificateUtils.isSelfSigned(certificate)) {
            try {
                Collection<X509Certificate> issuers = CertificateUtils.getIssuerCertificates(certificate);
                for (X509Certificate issuer : issuers) {
                    chain.addAll(CertificateUtils.getCertificateChain(issuer, maxDepth - 1));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return chain;
    }

    public static boolean isSelfSigned(X509Certificate certificate) {
        return certificate.getSubjectDN().equals(certificate.getIssuerDN());
    }

    public static List<X509Certificate> getFullCertificateChain(Collection<X509Certificate> chain) {
        Set missingIssuerNames = chain.stream().map(c -> c.getIssuerX500Principal().getName()).collect(Collectors.toCollection(LinkedHashSet::new));
        for (X509Certificate x509Certificate : chain) {
            missingIssuerNames.remove(x509Certificate.getSubjectX500Principal().getName());
        }
        HashSet<X509Certificate> orphanCertificates = new HashSet<X509Certificate>();
        for (X509Certificate certificate : chain) {
            if (!missingIssuerNames.contains(certificate.getIssuerX500Principal().getName())) continue;
            orphanCertificates.add(certificate);
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(chain);
        for (X509Certificate orphanCertificate : orphanCertificates) {
            arrayList.remove(orphanCertificate);
            arrayList.addAll(CertificateUtils.getCertificateChain(orphanCertificate, 10));
        }
        return arrayList;
    }
}

