/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.http.server.servlet;

import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import net.javacrumbs.smock.http.server.servlet.ApplicationContextWrapper;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServletUtils {
    private static final WeakHashMap<ApplicationContext, HttpServlet> servletCache = new WeakHashMap();

    private ServletUtils() {
    }

    public static HttpServlet createServlet(Class<? extends HttpServlet> servletClass, ApplicationContext applicationContext, String basePath, Map<String, String> initParameters) {
        if (servletCache.containsKey(applicationContext)) {
            return servletCache.get(applicationContext);
        }
        Assert.notNull(servletClass, (String)"servletClass has to be specified.");
        HttpServlet servlet = (HttpServlet)BeanUtils.instantiate(servletClass);
        MockServletContext context = new MockServletContext(basePath, (ResourceLoader)applicationContext);
        MockServletConfig config = new MockServletConfig((ServletContext)context);
        if (applicationContext != null) {
            config.getServletContext().setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)new ApplicationContextWrapper(applicationContext, config.getServletContext()));
        }
        if (initParameters != null) {
            for (Map.Entry<String, String> param : initParameters.entrySet()) {
                config.addInitParameter(param.getKey(), param.getValue());
            }
        }
        try {
            servlet.init((ServletConfig)config);
        }
        catch (ServletException e) {
            throw new IllegalStateException("Error when creating servlet " + servletClass.getName(), e);
        }
        if (applicationContext != null) {
            servletCache.put(applicationContext, servlet);
        }
        return servlet;
    }

    public static void clearCache() {
        servletCache.clear();
    }
}

