/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.metrics.druid;

import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.dreamlu.mica.metrics.druid.DruidDataSourcePoolMetadata;
import net.dreamlu.mica.metrics.druid.DruidMetrics;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={MetricsAutoConfiguration.class, DataSourceAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={DruidDataSource.class, MeterRegistry.class})
@ConditionalOnBean(value={DataSource.class, MeterRegistry.class})
public class DruidMetricsConfiguration {
    private static final String DATASOURCE_SUFFIX = "dataSource";

    @Bean
    public DataSourcePoolMetadataProvider druidDataSourceMetadataProvider() {
        return dataSource -> {
            DruidDataSource druidDataSource = (DruidDataSource)DataSourceUnwrapper.unwrap((DataSource)dataSource, DruidDataSource.class);
            if (druidDataSource != null) {
                return new DruidDataSourcePoolMetadata(druidDataSource);
            }
            return null;
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public StatFilter statFilter() {
        return new StatFilter();
    }

    @Bean
    public DruidMetrics druidMetrics(ObjectProvider<Map<String, DataSource>> dataSourcesProvider) {
        Map dataSourceMap = (Map)dataSourcesProvider.getIfAvailable(HashMap::new);
        HashMap<String, DruidDataSource> druidDataSourceMap = new HashMap<String, DruidDataSource>(2);
        dataSourceMap.forEach((name, dataSource) -> {
            DruidDataSource druidDataSource = (DruidDataSource)DataSourceUnwrapper.unwrap((DataSource)dataSource, DruidDataSource.class);
            if (druidDataSource != null) {
                druidDataSourceMap.put(DruidMetricsConfiguration.getDataSourceName(name), druidDataSource);
            }
        });
        return druidDataSourceMap.isEmpty() ? null : new DruidMetrics(druidDataSourceMap);
    }

    private static String getDataSourceName(String beanName) {
        if (beanName.length() > DATASOURCE_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)DATASOURCE_SUFFIX)) {
            return beanName.substring(0, beanName.length() - DATASOURCE_SUFFIX.length());
        }
        return beanName;
    }
}

