/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.HttpParameter;
import net.bull.javamelody.internal.common.HttpPart;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Action;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorServer;
import net.bull.javamelody.internal.model.ConnectionInformations;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.CounterRequestAggregation;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.HsErrPid;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JndiBinding;
import net.bull.javamelody.internal.model.LabradorRetriever;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.model.RemoteCollector;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.model.SessionInformations;
import net.bull.javamelody.internal.model.ThreadInformations;
import net.bull.javamelody.internal.model.TransportFormat;
import net.bull.javamelody.internal.web.CompressionServletResponseWrapper;
import net.bull.javamelody.internal.web.HttpCookieManager;
import net.bull.javamelody.internal.web.MonitoringController;
import net.bull.javamelody.internal.web.SerializableController;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlReport;
import org.apache.log4j.Logger;

public class CollectorController {
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private static final String COOKIE_NAME = "javamelody.application";
    private static final boolean CSRF_PROTECTION_ENABLED = Parameter.CSRF_PROTECTION_ENABLED.getValueAsBoolean();
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final CollectorServer collectorServer;

    public CollectorController(CollectorServer collectorServer) {
        assert (collectorServer != null);
        this.collectorServer = collectorServer;
    }

    public void addCollectorApplication(String appName, String appUrls) throws IOException {
        File file = Parameters.getCollectorApplicationsFile();
        if (file.exists() && !file.canWrite()) {
            throw new IllegalStateException("applications should be added or removed in the applications.properties file, because the user is not allowed to write: " + file);
        }
        List<URL> urls = Parameters.parseUrls(appUrls);
        this.collectorServer.addCollectorApplication(appName, urls);
    }

    public void addCollectorAggregationApplication(String aggregationApplication, List<String> aggregatedApplications) throws IOException {
        File file = Parameters.getCollectorApplicationsFile();
        if (file.exists() && !file.canWrite()) {
            throw new IllegalStateException("applications should be added or removed in the applications.properties file, because the user is not allowed to write: " + file);
        }
        this.collectorServer.addCollectorAggregationApplication(aggregationApplication, aggregatedApplications);
    }

    public void removeCollectorApplicationNodes(String appName, String nodeUrls) throws IOException {
        List<URL> urls = Parameters.parseUrls(nodeUrls);
        this.collectorServer.removeCollectorApplicationNodes(appName, urls);
    }

    public void doMonitoring(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        try {
            String actionParameter = HttpParameter.ACTION.getParameterFrom(req);
            if (actionParameter != null) {
                if (CSRF_PROTECTION_ENABLED) {
                    MonitoringController.checkCsrfToken(req);
                }
                if ("remove_application".equalsIgnoreCase(actionParameter)) {
                    this.collectorServer.removeCollectorApplication(application);
                    LOGGER.info((Object)("monitored application removed: " + application));
                    String messageForReport = I18N.getFormattedString("application_enlevee", application);
                    CollectorController.showAlertAndRedirectTo(resp, messageForReport, "?");
                    return;
                }
                Collector collector = this.getCollectorByApplication(application);
                MonitoringController monitoringController = new MonitoringController(collector, this.collectorServer);
                Action action = Action.valueOfIgnoreCase(actionParameter);
                String messageForReport = action != Action.CLEAR_COUNTER && action != Action.MAIL_TEST && action != Action.PURGE_OBSOLETE_FILES ? this.forwardActionAndUpdateData(req, application) : monitoringController.executeActionIfNeeded(req);
                if (TransportFormat.isATransportFormat(HttpParameter.FORMAT.getParameterFrom(req))) {
                    SerializableController serializableController = new SerializableController(collector);
                    Range range = serializableController.getRangeForSerializable(req);
                    List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
                    ArrayList serializable = new ArrayList((List)((Object)serializableController.createDefaultSerializable(javaInformationsList, range, messageForReport)));
                    monitoringController.doCompressedSerializable(req, resp, serializable);
                } else {
                    this.writeMessage(req, resp, application, messageForReport);
                }
                return;
            }
            this.doReport(req, resp, application);
        }
        catch (Exception e) {
            this.writeMessage(req, resp, application, e.getMessage());
        }
    }

    private void doReport(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException, ServletException {
        Collector collector = this.getCollectorByApplication(application);
        MonitoringController monitoringController = new MonitoringController(collector, this.collectorServer);
        String partParameter = HttpParameter.PART.getParameterFrom(req);
        String formatParameter = HttpParameter.FORMAT.getParameterFrom(req);
        if (HttpParameter.JMX_VALUE.getParameterFrom(req) != null) {
            this.doJmxValue(req, resp, application, HttpParameter.JMX_VALUE.getParameterFrom(req));
        } else if (TransportFormat.isATransportFormat(formatParameter)) {
            this.doCompressedSerializable(req, resp, application, monitoringController);
        } else if (partParameter == null || "pdf".equalsIgnoreCase(formatParameter)) {
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            monitoringController.doReport(req, resp, javaInformationsList);
        } else {
            this.doCompressedPart(req, resp, application, monitoringController);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompressedPart(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String application, MonitoringController monitoringController) throws IOException, ServletException {
        if (MonitoringController.isCompressionSupported(httpRequest, httpResponse)) {
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 4096);
            try {
                this.doPart(httpRequest, (HttpServletResponse)wrappedResponse, application, monitoringController);
            }
            finally {
                wrappedResponse.finishResponse();
            }
        } else {
            this.doPart(httpRequest, httpResponse, application, monitoringController);
        }
    }

    private void doPart(HttpServletRequest req, HttpServletResponse resp, String application, MonitoringController monitoringController) throws IOException, ServletException {
        if (HttpPart.WEB_XML.isPart(req) || HttpPart.POM_XML.isPart(req) || HttpPart.DEPENDENCIES.isPart(req) || HttpPart.SPRING_BEANS.isPart(req)) {
            CollectorController.noCache(resp);
            URL url = this.getUrlsByApplication(application).get(0);
            this.doProxy(req, resp, url, HttpParameter.PART.getParameterFrom(req));
        } else if (HttpPart.SOURCE.isPart(req)) {
            CollectorController.noCache(resp);
            URL url = this.getUrlsByApplication(application).get(0);
            this.doProxy(req, resp, url, HttpPart.SOURCE.getName() + '&' + (Object)((Object)HttpParameter.CLASS) + '=' + HttpParameter.CLASS.getParameterFrom(req));
        } else if (HttpPart.CRASHES.isPart(req) && HttpParameter.PATH.getParameterFrom(req) != null) {
            CollectorController.noCache(resp);
            this.doCrashDownload(req, resp, application);
        } else if (HttpPart.CONNECTIONS.isPart(req)) {
            this.doMultiHtmlProxy(req, resp, application, HttpPart.CONNECTIONS.getName(), I18N.getString("Connexions_jdbc_ouvertes"), I18N.getString("connexions_intro"), "db.png");
        } else if (HttpPart.CACHE_KEYS.isPart(req)) {
            String cacheId = HttpParameter.CACHE_ID.getParameterFrom(req);
            this.doMultiHtmlProxy(req, resp, application, HttpPart.CACHE_KEYS.toString() + '&' + (Object)((Object)HttpParameter.CACHE_ID) + '=' + cacheId, I18N.getFormattedString("Keys_cache", cacheId), null, "caches.png");
        } else if (HttpPart.JCACHE_KEYS.isPart(req)) {
            String cacheId = HttpParameter.CACHE_ID.getParameterFrom(req);
            this.doMultiHtmlProxy(req, resp, application, HttpPart.JCACHE_KEYS.toString() + '&' + (Object)((Object)HttpParameter.CACHE_ID) + '=' + cacheId, I18N.getFormattedString("Keys_cache", cacheId), null, "caches.png");
        } else {
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            monitoringController.doReport(req, resp, javaInformationsList);
        }
    }

    private void doCrashDownload(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        String partParameter = HttpPart.CRASHES.getName() + '&' + (Object)((Object)HttpParameter.PATH) + '=' + HttpParameter.PATH.getParameterFrom(req);
        boolean found = false;
        for (URL url : this.getUrlsByApplication(application)) {
            try {
                this.doProxy(req, resp, url, partParameter);
                found = true;
                break;
            }
            catch (IOException e) {
            }
        }
        if (!found) {
            resp.sendError(404);
        }
    }

    private void doJmxValue(HttpServletRequest req, HttpServletResponse resp, String application, String jmxValueParameter) throws IOException {
        CollectorController.noCache(resp);
        resp.setContentType("text/plain");
        boolean first = true;
        for (URL url : this.getUrlsByApplication(application)) {
            if (first) {
                first = false;
            } else {
                resp.getOutputStream().write(124);
                resp.getOutputStream().write(124);
            }
            URL proxyUrl = new URL(url.toString().replace(TransportFormat.SERIALIZED.getCode(), "").replace(TransportFormat.XML.getCode(), "") + '&' + (Object)((Object)HttpParameter.JMX_VALUE) + '=' + jmxValueParameter);
            new LabradorRetriever(proxyUrl).copyTo(req, resp);
        }
        resp.getOutputStream().close();
    }

    private void doProxy(HttpServletRequest req, HttpServletResponse resp, URL url, String partParameter) throws IOException {
        URL proxyUrl = new URL(url.toString().replace(TransportFormat.SERIALIZED.getCode(), "htmlbody").replace(TransportFormat.XML.getCode(), "htmlbody") + '&' + (Object)((Object)HttpParameter.PART) + '=' + partParameter);
        new LabradorRetriever(proxyUrl).copyTo(req, resp);
    }

    private void doMultiHtmlProxy(HttpServletRequest req, HttpServletResponse resp, String application, String partParameter, String title, String introduction, String iconName) throws IOException {
        PrintWriter writer = CollectorController.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer, application);
        htmlReport.writeHtmlHeader();
        writer.write("<div class='noPrint'>");
        I18N.writelnTo("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", writer);
        writer.write("<a href='?part=");
        writer.write(partParameter);
        writer.write("'>");
        I18N.writelnTo("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#", writer);
        writer.write("</a></div>");
        if (introduction != null) {
            writer.write("<br/>");
            writer.write(I18N.htmlEncode(introduction, false));
        }
        for (URL url : this.getUrlsByApplication(application)) {
            String htmlTitle = "<h3 class='chapterTitle'><img src='?resource=" + iconName + "' alt='" + I18N.urlEncode(title) + "'/>&nbsp;" + I18N.htmlEncode(title, false) + " (" + CollectorController.getHostAndPort(url) + ")</h3>";
            writer.write(htmlTitle);
            writer.flush();
            this.doProxy(req, resp, url, partParameter);
        }
        htmlReport.writeHtmlFooter();
        writer.close();
    }

    private void doCompressedSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String application, MonitoringController monitoringController) throws IOException {
        Serializable serializable;
        try {
            serializable = this.createSerializable(httpRequest, application);
        }
        catch (Exception e) {
            serializable = e;
        }
        monitoringController.doCompressedSerializable(httpRequest, httpResponse, serializable);
    }

    private Serializable createSerializable(HttpServletRequest httpRequest, String application) throws Exception {
        Serializable resultForSystemActions = this.createSerializableForSystemActions(httpRequest, application);
        if (resultForSystemActions != null) {
            return resultForSystemActions;
        }
        Collector collector = this.getCollectorByApplication(application);
        SerializableController serializableController = new SerializableController(collector);
        Range range = serializableController.getRangeForSerializable(httpRequest);
        if (HttpPart.THREADS.isPart(httpRequest)) {
            return new ArrayList<List<ThreadInformations>>(this.collectorServer.getThreadInformationsLists(application));
        }
        if (HttpPart.CURRENT_REQUESTS.isPart(httpRequest)) {
            return new LinkedHashMap<JavaInformations, List<CounterRequestContext>>(this.collectorServer.collectCurrentRequests(application));
        }
        if (HttpPart.EXPLAIN_PLAN.isPart(httpRequest)) {
            String sqlRequest = httpRequest.getHeader(HttpParameter.REQUEST.getName());
            return this.collectorServer.collectSqlRequestExplainPlan(application, sqlRequest);
        }
        if (HttpPart.COUNTER_SUMMARY_PER_CLASS.isPart(httpRequest)) {
            String counterName = HttpParameter.COUNTER.getParameterFrom(httpRequest);
            String requestId = HttpParameter.GRAPH.getParameterFrom(httpRequest);
            Counter counter = collector.getRangeCounter(range, counterName);
            List<CounterRequest> requestList = new CounterRequestAggregation(counter).getRequestsAggregatedOrFilteredByClassName(requestId);
            return new ArrayList<CounterRequest>(requestList);
        }
        if (HttpPart.APPLICATIONS.isPart(httpRequest)) {
            HashMap<String, Throwable> applications = new HashMap<String, Throwable>();
            for (String app : Parameters.getCollectorUrlsByApplications().keySet()) {
                applications.put(app, null);
            }
            applications.putAll(this.collectorServer.getLastCollectExceptionsByApplication());
            return new HashMap(applications);
        }
        if (HttpPart.JROBINS.isPart(httpRequest) || HttpPart.OTHER_JROBINS.isPart(httpRequest)) {
            return serializableController.createSerializable(httpRequest, null, null);
        }
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        return serializableController.createDefaultSerializable(javaInformationsList, range, null);
    }

    private Serializable createSerializableForSystemActions(HttpServletRequest httpRequest, String application) throws IOException {
        if (HttpPart.JVM.isPart(httpRequest)) {
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            return new ArrayList<JavaInformations>(javaInformationsList);
        }
        if (HttpPart.HEAP_HISTO.isPart(httpRequest)) {
            Action.checkSystemActionsEnabled();
            return this.collectorServer.collectHeapHistogram(application);
        }
        if (HttpPart.SESSIONS.isPart(httpRequest)) {
            Action.checkSystemActionsEnabled();
            String sessionId = HttpParameter.SESSION_ID.getParameterFrom(httpRequest);
            List<SessionInformations> sessionInformations = this.collectorServer.collectSessionInformations(application, sessionId);
            if (sessionId != null && !sessionInformations.isEmpty()) {
                return sessionInformations.get(0);
            }
            return new ArrayList<SessionInformations>(sessionInformations);
        }
        if (HttpPart.HOTSPOTS.isPart(httpRequest)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<SamplingProfiler.SampledMethod>(this.collectorServer.collectHotspots(application));
        }
        if (HttpPart.PROCESSES.isPart(httpRequest)) {
            Action.checkSystemActionsEnabled();
            return new LinkedHashMap<String, List<ProcessInformations>>(this.collectorServer.collectProcessInformations(application));
        }
        if (HttpPart.JNDI.isPart(httpRequest)) {
            Action.checkSystemActionsEnabled();
            String path = HttpParameter.PATH.getParameterFrom(httpRequest);
            return new ArrayList<JndiBinding>(this.collectorServer.collectJndiBindings(application, path));
        }
        if (HttpPart.MBEANS.isPart(httpRequest)) {
            Action.checkSystemActionsEnabled();
            return new LinkedHashMap<String, List<MBeanNode>>(this.collectorServer.collectMBeans(application));
        }
        if (HttpPart.DATABASE.isPart(httpRequest)) {
            Action.checkSystemActionsEnabled();
            int requestIndex = DatabaseInformations.parseRequestIndex(HttpParameter.REQUEST.getParameterFrom(httpRequest));
            return this.collectorServer.collectDatabaseInformations(application, requestIndex);
        }
        if (HttpPart.CONNECTIONS.isPart(httpRequest)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<List<ConnectionInformations>>(this.collectorServer.collectConnectionInformations(application));
        }
        if (HttpPart.CRASHES.isPart(httpRequest)) {
            Action.checkSystemActionsEnabled();
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            return new ArrayList<HsErrPid>(HsErrPid.getHsErrPidList(javaInformationsList));
        }
        return null;
    }

    private HtmlReport createHtmlReport(HttpServletRequest req, HttpServletResponse resp, PrintWriter writer, String application) {
        Range range = this.httpCookieManager.getRange(req, resp);
        Collector collector = this.getCollectorByApplication(application);
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        return new HtmlReport(collector, this.collectorServer, javaInformationsList, range, (Writer)writer);
    }

    private static String getHostAndPort(URL url) {
        return RemoteCollector.getHostAndPort(url);
    }

    public void writeMessage(HttpServletRequest req, HttpServletResponse resp, String application, String message) throws IOException {
        Collector collector = this.getCollectorByApplication(application);
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        if (application == null || collector == null || javaInformationsList == null) {
            CollectorController.showAlertAndRedirectTo(resp, message, "?");
        } else {
            PrintWriter writer = CollectorController.createWriterFromOutputStream(resp);
            String partToRedirectTo = HttpParameter.CACHE_ID.getParameterFrom(req) == null || HttpParameter.PART.getParameterFrom(req) == null ? HttpParameter.PART.getParameterFrom(req) : HttpParameter.PART.getParameterFrom(req) + '&' + (Object)((Object)HttpParameter.CACHE_ID) + '=' + HttpParameter.CACHE_ID.getParameterFrom(req);
            new HtmlReport(collector, this.collectorServer, javaInformationsList, Period.TOUT, (Writer)writer).writeMessageIfNotNull(message, partToRedirectTo);
            writer.close();
        }
    }

    private static PrintWriter createWriterFromOutputStream(HttpServletResponse httpResponse) throws IOException {
        CollectorController.noCache(httpResponse);
        return new PrintWriter(MonitoringController.getWriter(httpResponse));
    }

    public static void writeOnlyAddApplication(HttpServletResponse resp) throws IOException {
        PrintWriter writer = CollectorController.createWriterFromOutputStream(resp);
        writer.write("<html lang='" + I18N.getCurrentLocale().getLanguage() + "'><head><title>Monitoring</title></head><body>");
        List<String> applications = Collections.emptyList();
        HtmlReport.writeAddAndRemoveApplicationLinks(null, applications, writer);
        writer.write("</body></html>");
        writer.close();
    }

    public static void writeDataUnavailableForApplication(String application, HttpServletResponse resp) throws IOException {
        PrintWriter writer = CollectorController.createWriterFromOutputStream(resp);
        writer.write("<html lang='" + I18N.getCurrentLocale().getLanguage() + "'><head><title>Monitoring</title></head><body>");
        writer.write(I18N.htmlEncode(I18N.getFormattedString("data_unavailable", application), false));
        writer.write("<br/><br/>");
        writer.write("<a href='?'><img src='?resource=action_back.png' alt=\"" + I18N.getString("Retour") + "\"/> " + I18N.getString("Retour") + "</a>");
        if (Parameters.getCollectorApplicationsFile().canWrite()) {
            writer.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            writer.write("<a href='?action=remove_application&amp;application=" + I18N.urlEncode(application) + HtmlAbstractReport.getCsrfTokenUrlPart() + "' ");
            String messageConfirmation = I18N.getFormattedString("confirm_remove_application", application);
            writer.write("onclick=\"javascript:return confirm('" + I18N.javascriptEncode(messageConfirmation) + "');\">");
            String removeApplicationLabel = I18N.getFormattedString("remove_application", application);
            writer.write("<img src='?resource=action_delete.png' alt=\"" + removeApplicationLabel + "\"/> " + removeApplicationLabel + "</a>");
        }
        writer.write("</body></html>");
        writer.close();
    }

    public static void showAlertAndRedirectTo(HttpServletResponse resp, String message, String redirectTo) throws IOException {
        PrintWriter writer = CollectorController.createWriterFromOutputStream(resp);
        writer.write("<script type='text/javascript'>alert('");
        writer.write(I18N.javascriptEncode(message));
        writer.write("');location.href='");
        writer.write(redirectTo);
        writer.write("';</script>");
        writer.close();
    }

    private static void noCache(HttpServletResponse httpResponse) {
        MonitoringController.noCache(httpResponse);
    }

    private String forwardActionAndUpdateData(HttpServletRequest req, String application) throws IOException {
        String actionParameter = HttpParameter.ACTION.getParameterFrom(req);
        String sessionIdParameter = HttpParameter.SESSION_ID.getParameterFrom(req);
        String threadIdParameter = HttpParameter.THREAD_ID.getParameterFrom(req);
        String jobIdParameter = HttpParameter.JOB_ID.getParameterFrom(req);
        String cacheIdParameter = HttpParameter.CACHE_ID.getParameterFrom(req);
        String cacheKeyParameter = HttpParameter.CACHE_KEY.getParameterFrom(req);
        List<URL> urls = this.getUrlsByApplication(application);
        ArrayList<URL> actionUrls = new ArrayList<URL>(urls.size());
        for (URL url : urls) {
            StringBuilder actionUrl = new StringBuilder(url.toString());
            actionUrl.append("&action=").append(actionParameter);
            if (sessionIdParameter != null) {
                actionUrl.append("&sessionId=").append(sessionIdParameter);
            }
            if (threadIdParameter != null) {
                actionUrl.append("&threadId=").append(threadIdParameter);
            }
            if (jobIdParameter != null) {
                actionUrl.append("&jobId=").append(jobIdParameter);
            }
            if (cacheIdParameter != null) {
                actionUrl.append("&cacheId=").append(cacheIdParameter);
            }
            if (cacheKeyParameter != null) {
                actionUrl.append("&cacheKey=").append(cacheKeyParameter);
            }
            actionUrls.add(new URL(actionUrl.toString()));
        }
        return this.collectorServer.collectForApplicationForAction(application, actionUrls);
    }

    public String getApplication(HttpServletRequest req, HttpServletResponse resp) throws UnsupportedEncodingException {
        String application = req.getParameter("application");
        if (application == null) {
            Cookie cookie = this.httpCookieManager.getCookieByName(req, COOKIE_NAME);
            if (cookie != null && !this.collectorServer.isApplicationDataAvailable(application = URLDecoder.decode(cookie.getValue(), "UTF-8"))) {
                cookie.setMaxAge(-1);
                resp.addCookie(cookie);
                application = null;
            }
            if (application == null) {
                application = this.collectorServer.getFirstApplication();
            }
        } else if (this.collectorServer.isApplicationDataAvailable(application)) {
            this.httpCookieManager.addCookie(req, resp, COOKIE_NAME, URLEncoder.encode(application, "UTF-8"));
        }
        return application;
    }

    private Collector getCollectorByApplication(String application) {
        return this.collectorServer.getCollectorByApplication(application);
    }

    private List<JavaInformations> getJavaInformationsByApplication(String application) {
        return this.collectorServer.getJavaInformationsByApplication(application);
    }

    private List<URL> getUrlsByApplication(String application) {
        return this.collectorServer.getUrlsByApplication(application);
    }
}

