/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.common;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MessageDigestPasswordEncoder {
    private static final byte[] SALT = "javamelody".getBytes(StandardCharsets.UTF_8);
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private final String algorithm;

    public MessageDigestPasswordEncoder(String algorithm) {
        this.algorithm = algorithm;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        if (args.length == 0) {
            MessageDigestPasswordEncoder.print("No password to hash in arguments");
        } else {
            String algorithm = "SHA-256";
            MessageDigestPasswordEncoder messageDigestPasswordEncoder = new MessageDigestPasswordEncoder("SHA-256");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    MessageDigestPasswordEncoder.print(" ");
                }
                MessageDigestPasswordEncoder.print(messageDigestPasswordEncoder.encodePassword(args[i]));
            }
        }
    }

    private static void print(String msg) {
        System.out.print(msg);
    }

    public String encodePassword(String password) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
        messageDigest.update(password.getBytes(StandardCharsets.UTF_8));
        messageDigest.update(SALT);
        byte[] digest = messageDigest.digest();
        return "{" + this.algorithm + '}' + this.hexa(digest);
    }

    private String hexa(byte[] digest) {
        char[] chars = new char[digest.length * 2];
        for (int j = 0; j < digest.length; ++j) {
            int v = digest[j] & 0xFF;
            chars[j * 2] = HEX_ARRAY[v >>> 4];
            chars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(chars);
    }
}

