/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.daria.sql;

import com.github.mrpowers.spark.daria.sql.InvalidDataFrameSchemaException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y3Q!\u0001\u0002\u0001\u00059\u0011a\u0003R1uC\u001a\u0013\u0018-\\3TG\",W.Y\"iK\u000e\\WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003eCJL\u0017M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\t[J\u0004xn^3sg*\u00111\u0002D\u0001\u0007O&$\b.\u001e2\u000b\u00035\t1aY8n'\t\u0001q\u0002\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\u0005\t-\u0001\u0011\t\u0011)A\u00051\u0005\u0011AMZ\u0002\u0001!\tIRF\u0004\u0002\u001bU9\u00111\u0004\u000b\b\u00039\u0019r!!H\u0012\u000f\u0005y\tS\"A\u0010\u000b\u0005\u0001:\u0012A\u0002\u001fs_>$h(C\u0001#\u0003\ry'oZ\u0005\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0012\n\u0005\u001d9#B\u0001\u0013&\u0013\t\u0019\u0011F\u0003\u0002\bO%\u00111\u0006L\u0001\ba\u0006\u001c7.Y4f\u0015\t\u0019\u0011&\u0003\u0002/_\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0003W1B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b!\t\u0019d'D\u00015\u0015\t)D&A\u0003usB,7/\u0003\u00028i\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\rYTH\u0010\t\u0003y\u0001i\u0011A\u0001\u0005\u0006-a\u0002\r\u0001\u0007\u0005\u0006ca\u0002\rA\r\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0003Mi\u0017n]:j]\u001e\u001cFO];di\u001aKW\r\u001c3t+\u0005\u0011\u0005cA\"G\u00116\tAI\u0003\u0002F#\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d#%aA*fcB\u00111'S\u0005\u0003\u0015R\u00121b\u0015;sk\u000e$h)[3mI\"1A\n\u0001Q\u0001\n\t\u000bA#\\5tg&twm\u0015;sk\u000e$h)[3mIN\u0004\u0003\"\u0002(\u0001\t\u0003y\u0015AG7jgNLgnZ*ueV\u001cGOR5fY\u0012\u001cX*Z:tC\u001e,G#\u0001)\u0011\u0005E+fB\u0001*T!\tq\u0012#\u0003\u0002U#\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!\u0016\u0003C\u0003Z\u0001\u0011\u0005!,\u0001\bwC2LG-\u0019;f'\u000eDW-\\1\u0015\u0003m\u0003\"\u0001\u0005/\n\u0005u\u000b\"\u0001B+oSR\u0004")
public class DataFrameSchemaChecker {
    private final Dataset<Row> df;
    private final Seq<StructField> missingStructFields;

    public Seq<StructField> missingStructFields() {
        return this.missingStructFields;
    }

    public String missingStructFieldsMessage() {
        return new StringBuilder(88).append("The [").append(this.missingStructFields().mkString(", ")).append("] StructFields are not included in the DataFrame with the following StructFields [").append(this.df.schema().toString()).append("]").toString();
    }

    public void validateSchema() {
        if (this.missingStructFields().nonEmpty()) {
            throw new InvalidDataFrameSchemaException(this.missingStructFieldsMessage());
        }
    }

    public DataFrameSchemaChecker(Dataset<Row> df, StructType requiredSchema) {
        this.df = df;
        this.missingStructFields = (Seq)requiredSchema.diff((GenSeq)df.schema());
    }
}

