/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.daria.sql;

import com.github.mrpowers.spark.daria.sql.DataFrameValidator;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

public final class DataFrameHelpers$
implements DataFrameValidator {
    public static DataFrameHelpers$ MODULE$;
    private SparkSession spark;
    private volatile boolean bitmap$0;

    static {
        new DataFrameHelpers$();
    }

    @Override
    public void validatePresenceOfColumns(Dataset<Row> df, Seq<String> requiredColNames) {
        DataFrameValidator.validatePresenceOfColumns$(this, df, requiredColNames);
    }

    @Override
    public void validateSchema(Dataset<Row> df, StructType requiredSchema) {
        DataFrameValidator.validateSchema$(this, df, requiredSchema);
    }

    @Override
    public void validateAbsenceOfColumns(Dataset<Row> df, Seq<String> prohibitedColNames) {
        DataFrameValidator.validateAbsenceOfColumns$(this, df, prohibitedColNames);
    }

    public <keyType, valueType> Map<keyType, valueType> twoColumnsToMap(Dataset<Row> df, String keyColName, String valueColName, TypeTags.TypeTag<keyType> evidence$1, TypeTags.TypeTag<valueType> evidence$2) {
        this.validatePresenceOfColumns(df, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{keyColName, valueColName}))));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.select(keyColName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{valueColName})).collect())).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r.apply(0), r.apply(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public <T> Object columnToArray(Dataset<Row> df, String colName, ClassTag<T> evidence$3) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.select(colName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)r -> r.apply(0), Array$.MODULE$.canBuildFrom(evidence$3));
    }

    public <T> List<T> columnToList(Dataset<Row> df, String colName, ClassTag<T> evidence$4) {
        return Predef$.MODULE$.genericArrayOps(this.columnToArray(df, colName, evidence$4)).toList();
    }

    public Map<String, Object>[] toArrayOfMaps(Dataset<Row> df) {
        return (Map[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).map((Function1 & Serializable & scala.Serializable)r -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).zip((GenIterable)r.toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)));
    }

    public void printAthenaCreateTable(Dataset<Row> df, String athenaTableName, String s3location) {
        Seq fields = (Seq)df.schema().map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(1).append(f.name()).append(" ").append(MODULE$.sparkTypeToAthenaType(f.dataType().toString())).toString(), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new StringBuilder(37).append("CREATE EXTERNAL TABLE IF NOT EXISTS ").append(athenaTableName).append("(").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(2).append("  ").append(fields.mkString(",\n  ")).toString());
        Predef$.MODULE$.println((Object)")");
        Predef$.MODULE$.println((Object)"STORED AS PARQUET");
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("LOCATION '").append(s3location).append("'").toString());
    }

    public String sparkTypeToAthenaType(String sparkType) {
        String string = sparkType;
        String string2 = "StringType".equals(string) ? "STRING" : ("IntegerType".equals(string) ? "INT" : ("DateType".equals(string) ? "DATE" : ("DecimalType".equals(string) ? "DECIMAL" : ("FloatType".equals(string) ? "FLOAT" : ("LongType".equals(string) ? "BIGINT" : ("TimestampType".equals(string) ? "TIMESTAMP" : "STRING"))))));
        return string2;
    }

    private SparkSession spark$lzycompute() {
        DataFrameHelpers$ dataFrameHelpers$ = this;
        synchronized (dataFrameHelpers$) {
            if (!this.bitmap$0) {
                this.spark = SparkSession$.MODULE$.builder().master("local").appName("spark session").getOrCreate();
                this.bitmap$0 = true;
            }
        }
        return this.spark;
    }

    public SparkSession spark() {
        return !this.bitmap$0 ? this.spark$lzycompute() : this.spark;
    }

    public void writeTimestamped(Dataset<Row> df, String outputDirname, Option<Object> numPartitions, boolean overwriteLatest) {
        block2: {
            String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String outputPath = new StringBuilder(1).append(outputDirname).append("/").append(timestamp).toString();
            if (numPartitions.isEmpty()) {
                df.write().parquet(outputPath);
            } else {
                int p = BoxesRunTime.unboxToInt((Object)numPartitions.get());
                df.repartition(p).write().parquet(outputPath);
            }
            if (!overwriteLatest) break block2;
            Seq latestData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputPath}))}));
            .colon.colon latestSchema = new .colon.colon((Object)new StructField("latest_path", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$);
            Dataset latestDF = this.spark().createDataFrame(this.spark().sparkContext().parallelize(latestData, this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Row.class)), StructType$.MODULE$.apply((Seq)latestSchema));
            latestDF.write().option("header", "false").option("delimiter", ",").mode(SaveMode.Overwrite).csv(new StringBuilder(7).append(outputDirname).append("/latest").toString());
        }
    }

    public Option<Object> writeTimestamped$default$3() {
        return None$.MODULE$;
    }

    public boolean writeTimestamped$default$4() {
        return true;
    }

    public Dataset<Row> readTimestamped(String dirname) {
        Dataset latestDF = this.spark().read().option("header", "false").option("delimiter", ",").csv(new StringBuilder(7).append(dirname).append("/latest").toString());
        String latestPath = ((Row)latestDF.head()).getString(0);
        return this.spark().read().parquet(latestPath);
    }

    private DataFrameHelpers$() {
        MODULE$ = this;
        DataFrameValidator.$init$(this);
    }
}

