/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.daria.sql;

import com.github.mrpowers.spark.daria.sql.MissingDataFrameColumnsException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Predef$;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3Q!\u0001\u0002\u0001\u00059\u0011q\u0003R1uC\u001a\u0013\u0018-\\3D_2,XN\\:DQ\u0016\u001c7.\u001a:\u000b\u0005\r!\u0011aA:rY*\u0011QAB\u0001\u0006I\u0006\u0014\u0018.\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\u00115\u0014\bo\\<feNT!a\u0003\u0007\u0002\r\u001dLG\u000f[;c\u0015\u0005i\u0011aA2p[N\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011Y\u0001!\u0011!Q\u0001\na\t!\u0001\u001a4\u0004\u0001A\u0011\u0011$\f\b\u00035)r!a\u0007\u0015\u000f\u0005q1cBA\u000f$\u001d\tq\u0012%D\u0001 \u0015\t\u0001s#\u0001\u0004=e>|GOP\u0005\u0002E\u0005\u0019qN]4\n\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001#\u0013\t9qE\u0003\u0002%K%\u00111!\u000b\u0006\u0003\u000f\u001dJ!a\u000b\u0017\u0002\u000fA\f7m[1hK*\u00111!K\u0005\u0003]=\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005-b\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002!I,\u0017/^5sK\u0012\u001cu\u000e\u001c(b[\u0016\u001c\bcA\u001a8u9\u0011AG\u000e\b\u0003=UJ\u0011AE\u0005\u0003WEI!\u0001O\u001d\u0003\u0007M+\u0017O\u0003\u0002,#A\u00111h\u0010\b\u0003yu\u0002\"AH\t\n\u0005y\n\u0012A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!AP\t\t\u000b\r\u0003A\u0011\u0001#\u0002\rqJg.\u001b;?)\r)u\t\u0013\t\u0003\r\u0002i\u0011A\u0001\u0005\u0006-\t\u0003\r\u0001\u0007\u0005\u0006c\t\u0003\rA\r\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u00039i\u0017n]:j]\u001e\u001cu\u000e\\;n]N,\u0012\u0001\u0014\t\u0004\u001bBST\"\u0001(\u000b\u0005=\u000b\u0012AC2pY2,7\r^5p]&\u0011\u0001H\u0014\u0005\u0007%\u0002\u0001\u000b\u0011\u0002'\u0002\u001f5L7o]5oO\u000e{G.^7og\u0002BQ\u0001\u0016\u0001\u0005\u0002U\u000bQ#\\5tg&twmQ8mk6t7/T3tg\u0006<W\rF\u0001;\u0011\u00159\u0006\u0001\"\u0001Y\u0003e1\u0018\r\\5eCR,\u0007K]3tK:\u001cWm\u00144D_2,XN\\:\u0015\u0003e\u0003\"\u0001\u0005.\n\u0005m\u000b\"\u0001B+oSR\u0004")
public class DataFrameColumnsChecker {
    private final Dataset<Row> df;
    private final Seq<String> missingColumns;

    public Seq<String> missingColumns() {
        return this.missingColumns;
    }

    public String missingColumnsMessage() {
        String missingColNames = this.missingColumns().mkString(", ");
        String allColNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.df.columns())).mkString(", ");
        return new StringBuilder(78).append("The [").append(missingColNames).append("] columns are not included in the DataFrame with the following columns [").append(allColNames).append("]").toString();
    }

    public void validatePresenceOfColumns() {
        if (this.missingColumns().nonEmpty()) {
            throw new MissingDataFrameColumnsException(this.missingColumnsMessage());
        }
    }

    public DataFrameColumnsChecker(Dataset<Row> df, Seq<String> requiredColNames) {
        this.df = df;
        this.missingColumns = (Seq)requiredColNames.diff((GenSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).toSeq());
    }
}

