/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class MixerSupportRegistry {
    private Map<String, Class<?>> registry;

    public Map<String, Class<?>> loadFromProperties(String propertiesFileName) {
        if (this.registry == null) {
            this.registry = new HashMap(17);
            Properties props = new Properties();
            try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFileName + ".properties");){
                props.load(inputStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't load " + propertiesFileName + ".properties from classpath", e);
            }
            this.registry = props.entrySet().parallelStream().collect(Collectors.toMap(k -> k.getKey().toString(), v -> {
                String className = v.getValue().toString();
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(className + " doesn't appear to be a known Istio " + propertiesFileName + " class", e);
                }
            }));
        }
        return this.registry;
    }

    public Class<?> getImplementationClass(String id) {
        Class<?> targetClass = this.registry.get(id);
        if (targetClass == null) {
            throw new RuntimeException("No implementation class associated with " + id);
        }
        return targetClass;
    }
}

