/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import org.jboss.test.logging.LoggingPlugin;
import org.jboss.test.security.PolicyPlugin;

public class AbstractTestDelegate {
    protected Class clazz;
    public boolean enableSecurity = false;
    protected PolicyPlugin policy;
    protected LoggingPlugin logging;
    protected Logger log;

    protected static AbstractTestDelegate getDelegate(Class clazz) throws Exception {
        NoSuchMethodException original = null;
        while (true) {
            try {
                Method method = clazz.getMethod("getDelegate", Class.class);
                AbstractTestDelegate delegate = (AbstractTestDelegate)method.invoke(null, clazz);
                return delegate;
            }
            catch (NoSuchMethodException e) {
                if (original != null) continue;
                original = e;
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw original;
            }
            break;
        }
    }

    public AbstractTestDelegate(Class clazz) {
        this.clazz = clazz;
    }

    protected Logger getLog() {
        return this.log;
    }

    protected void enableTrace(String name) {
        this.logging.enableTrace(name);
    }

    public void setUp() throws Exception {
        this.setUpLogging();
        this.log("setUp");
        if (this.enableSecurity) {
            this.setUpSecurity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            if (this.enableSecurity) {
                this.tearDownSecurity();
            }
        }
        finally {
            this.tearDownLogging();
        }
        this.log("tornDown");
    }

    public void setUpLogging() throws Exception {
        this.logging = LoggingPlugin.getInstance();
        this.logging.setUp();
        this.log = Logger.getLogger((Class)this.clazz);
    }

    public void tearDownLogging() throws Exception {
        this.logging.tearDown();
    }

    protected void setUpSecurity() throws Exception {
        this.policy = PolicyPlugin.getInstance(this.clazz);
        PolicyPlugin.setPolicy(this.policy);
        System.setSecurityManager(new SecurityManager());
    }

    public void tearDownSecurity() throws Exception {
        System.setSecurityManager(null);
    }

    protected void log(String context) {
        this.getLog().debug((Object)("==== " + context + " " + this.clazz.getName() + " ===="));
    }
}

