/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.propagation.TraceContext;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.api.ProcessingContext;
import org.apache.kafka.streams.processor.api.RecordMetadata;

abstract class TracingProcessingContext<C extends ProcessingContext>
implements ProcessingContext {
    final C delegate;
    final TraceContext.Injector<Headers> injector;
    final TraceContext context;

    TracingProcessingContext(C delegate, TraceContext.Injector<Headers> injector, TraceContext context) {
        this.delegate = delegate;
        this.injector = injector;
        this.context = context;
    }

    public String applicationId() {
        return this.delegate.applicationId();
    }

    public TaskId taskId() {
        return this.delegate.taskId();
    }

    public Optional<RecordMetadata> recordMetadata() {
        return this.delegate.recordMetadata();
    }

    public Serde<?> keySerde() {
        return this.delegate.keySerde();
    }

    public Serde<?> valueSerde() {
        return this.delegate.valueSerde();
    }

    public File stateDir() {
        return this.delegate.stateDir();
    }

    public StreamsMetrics metrics() {
        return this.delegate.metrics();
    }

    public <S extends StateStore> S getStateStore(String s) {
        return (S)this.delegate.getStateStore(s);
    }

    public Cancellable schedule(Duration duration, PunctuationType punctuationType, Punctuator punctuator) {
        return this.delegate.schedule(duration, punctuationType, punctuator);
    }

    public void commit() {
        this.delegate.commit();
    }

    public Map<String, Object> appConfigs() {
        return this.delegate.appConfigs();
    }

    public Map<String, Object> appConfigsWithPrefix(String s) {
        return this.delegate.appConfigsWithPrefix(s);
    }

    public long currentSystemTimeMs() {
        return this.delegate.currentSystemTimeMs();
    }

    public long currentStreamTimeMs() {
        return this.delegate.currentStreamTimeMs();
    }
}

