/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.Message;

final class TracingCompletionListener
implements CompletionListener {
    final CompletionListener delegate;
    final CurrentTraceContext current;
    @Nullable
    final Destination destination;
    final Span span;

    static CompletionListener create(CompletionListener delegate, @Nullable Destination destination, Span span, CurrentTraceContext current) {
        return new TracingCompletionListener(delegate, destination, span, current);
    }

    TracingCompletionListener(CompletionListener delegate, Destination destination, Span span, CurrentTraceContext current) {
        this.delegate = delegate;
        this.destination = destination;
        this.span = span;
        this.current = current;
    }

    public void onCompletion(Message message) {
        CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
        try {
            this.delegate.onCompletion(message);
        }
        finally {
            this.span.finish();
            ws.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(Message message, Exception exception) {
        CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
        try {
            this.delegate.onException(message, exception);
        }
        finally {
            this.span.error((Throwable)exception);
            this.span.finish();
            ws.close();
        }
    }
}

