/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.tracing.QueryRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class TracingTestBase {
    Vertx vertx;
    VertxTracer tracer;
    Pool pool;

    @Before
    public void setup() throws Exception {
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setTracingOptions(new TracingOptions().setFactory(tracingOptions -> new VertxTracer(){

            public Object sendRequest(Context context, SpanKind kind, TracingPolicy tracingPolicy, Object request, String operation, BiConsumer headers, TagExtractor tagExtractor) {
                return TracingTestBase.this.tracer.sendRequest(context, kind, tracingPolicy, request, operation, headers, tagExtractor);
            }

            public void receiveResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                TracingTestBase.this.tracer.receiveResponse(context, response, payload, failure, tagExtractor);
            }
        })));
        this.pool = this.createPool(this.vertx);
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected abstract Pool createPool(Vertx var1);

    protected abstract String statement(String ... var1);

    @Test
    public void testTraceSimpleQuery(TestContext ctx) {
        String sql = "SELECT * FROM immutable WHERE id=1";
        this.testTraceQuery(ctx, sql, Collections.emptyList(), pool -> pool.withConnection(conn -> conn.query(sql).execute()));
    }

    @Test
    public void testTracePooledSimpleQuery(TestContext ctx) {
        String sql = "SELECT * FROM immutable WHERE id=1";
        this.testTraceQuery(ctx, sql, Collections.emptyList(), pool -> pool.query(sql).execute());
    }

    @Test
    public void testTracePreparedQuery(TestContext ctx) {
        String sql = this.statement("SELECT * FROM immutable WHERE id = ", "");
        Tuple tuple = Tuple.of((Object)1);
        this.testTraceQuery(ctx, sql, Collections.singletonList(tuple), pool -> pool.withConnection(conn -> conn.preparedQuery(sql).execute(tuple)));
    }

    @Test
    public void testTracePooledPreparedQuery(TestContext ctx) {
        String sql = this.statement("SELECT * FROM immutable WHERE id = ", "");
        Tuple tuple = Tuple.of((Object)1);
        this.testTraceQuery(ctx, sql, Collections.singletonList(tuple), pool -> pool.preparedQuery(sql).execute(tuple));
    }

    @Test
    public void testTraceBatchQuery(TestContext ctx) {
        String sql = this.statement("SELECT * FROM immutable WHERE id = ", "");
        List<Tuple> tuples = Arrays.asList(Tuple.of((Object)1), Tuple.of((Object)2));
        this.testTraceQuery(ctx, sql, tuples, pool -> pool.withConnection(conn -> conn.preparedQuery(sql).executeBatch(tuples)));
    }

    @Test
    public void testTracePooledBatchQuery(TestContext ctx) {
        String sql = this.statement("SELECT * FROM immutable WHERE id = ", "");
        List<Tuple> tuples = Arrays.asList(Tuple.of((Object)1), Tuple.of((Object)2));
        this.testTraceQuery(ctx, sql, tuples, pool -> pool.preparedQuery(sql).executeBatch(tuples));
    }

    public void testTraceQuery(final TestContext ctx, final String expectedSql, final List<Tuple> expectedTuples, Function<Pool, Future<?>> fn) {
        final AtomicBoolean called = new AtomicBoolean();
        final AtomicReference requestContext = new AtomicReference();
        final AtomicReference responseContext = new AtomicReference();
        final Async completed = ctx.async(2);
        final Object expectedPayload = new Object();
        this.tracer = new VertxTracer<Object, Object>(){

            public <R> Object sendRequest(Context context, SpanKind kind, TracingPolicy tracingPolicy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
                QueryRequest query = (QueryRequest)request;
                ctx.assertEquals((Object)expectedSql, (Object)query.sql());
                ctx.assertEquals((Object)expectedTuples, (Object)query.tuples());
                Map tags = tagExtractor.extract(request);
                ctx.assertEquals((Object)"client", tags.get("span.kind"));
                ctx.assertEquals((Object)"sql", tags.get("db.type"));
                ctx.assertEquals((Object)expectedSql, tags.get("db.statement"));
                requestContext.set(context);
                completed.countDown();
                return expectedPayload;
            }

            public <R> void receiveResponse(Context context, R response, Object payload, Throwable failure, TagExtractor<R> tagExtractor) {
                RowSet rs = (RowSet)response;
                ctx.assertTrue(rs.iterator().hasNext());
                ctx.assertEquals(expectedPayload, payload);
                ctx.assertNull((Object)failure);
                called.set(true);
                responseContext.set(context);
                completed.countDown();
            }
        };
        Async async = ctx.async();
        this.vertx.runOnContext(v1 -> {
            Context context = Vertx.currentContext();
            ((Future)fn.apply(this.pool)).onComplete(ctx.asyncAssertSuccess(v2 -> this.vertx.runOnContext(v4 -> {
                completed.await(2000L);
                ctx.assertEquals((Object)context, requestContext.get());
                ctx.assertEquals((Object)context, responseContext.get());
                ctx.assertTrue(called.get());
                async.complete();
            })));
        });
    }

    @Test
    public void testTracingFailure(final TestContext ctx) {
        final Async completed = ctx.async();
        this.tracer = new VertxTracer<Object, Object>(){

            public <R> Object sendRequest(Context context, SpanKind kind, TracingPolicy tracingPolicy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
                return null;
            }

            public <R> void receiveResponse(Context context, R response, Object payload, Throwable failure, TagExtractor<R> tagExtractor) {
                ctx.assertNull(response);
                ctx.assertNotNull((Object)failure);
                completed.complete();
            }
        };
        this.pool.getConnection(ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("SELECT * FROM undefined_table WHERE id = ", "")).execute(Tuple.of((Object)0), ctx.asyncAssertFailure(err -> conn.close()))));
    }

    @Test
    public void testMappingFailure(final TestContext ctx) {
        RuntimeException failure = new RuntimeException();
        final AtomicInteger called = new AtomicInteger();
        final Async completed = ctx.async();
        String sql = this.statement("SELECT * FROM immutable WHERE id = ", "");
        this.tracer = new VertxTracer<Object, Object>(){

            public <R> Object sendRequest(Context context, SpanKind kind, TracingPolicy tracingPolicy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
                return null;
            }

            public <R> void receiveResponse(Context context, R response, Object payload, Throwable failure, TagExtractor<R> tagExtractor) {
                ctx.assertEquals((Object)1, (Object)called.incrementAndGet());
                completed.complete();
            }
        };
        Async async = ctx.async();
        this.pool.getConnection(ctx.asyncAssertSuccess(conn -> conn.preparedQuery(sql).mapping(row -> {
            throw failure;
        }).execute(Tuple.of((Object)1), ctx.asyncAssertFailure(err -> conn.close(ctx.asyncAssertSuccess(v1 -> this.vertx.runOnContext(v2 -> {
            completed.await(2000L);
            ctx.assertEquals((Object)1, (Object)called.get());
            async.complete();
        })))))));
    }
}

