/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.RowStreamInternal;
import io.vertx.sqlclient.tck.Connector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class PreparedQueryTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;
    protected SqlConnectOptions options;
    protected Consumer<Throwable> msgVerifier;

    private static void insertIntoTestTable(TestContext ctx, SqlClient client, int amount, Runnable completionHandler) {
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < 10; ++i) {
            client.query("INSERT INTO mutable (id, val) VALUES (" + i + ", 'Whatever-" + i + "')").execute(ctx.asyncAssertSuccess(r1 -> {
                ctx.assertEquals((Object)1, (Object)r1.rowCount());
                if (count.incrementAndGet() == amount) {
                    completionHandler.run();
                }
            }));
        }
    }

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    protected abstract String statement(String ... var1);

    protected abstract void initConnector();

    protected boolean cursorRequiresTx() {
        return true;
    }

    @Before
    public void setUp(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
        this.cleanTestTable(ctx);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.msgVerifier = null;
        this.connector.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testPrepare(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.prepare(this.statement("SELECT id, message from immutable where id=", "")).compose(PreparedStatement::close).onComplete(ctx.asyncAssertSuccess(result -> conn.close()))));
    }

    @Test
    public void testPrepareError(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT whatever from DOES_NOT_EXIST", ctx.asyncAssertFailure(error -> {
            if (this.msgVerifier != null) {
                this.msgVerifier.accept((Throwable)error);
            }
        }))));
    }

    @Test
    public void testPreparedQuery(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("SELECT * FROM immutable WHERE id=", "")).execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            Tuple row = (Tuple)rowSet.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
            conn.close();
        }))));
    }

    @Test
    public void testPreparedQueryWithWrappedParams(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("SELECT * FROM immutable WHERE id=", "")).execute(Tuple.wrap(Arrays.asList(1)), ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            Tuple row = (Tuple)rowSet.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
            conn.close();
        }))));
    }

    @Test
    public void testPreparedQueryParamCoercionTypeError(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", ""), ctx.asyncAssertSuccess(ps -> ps.query().execute(Tuple.of((Object)"1"), ctx.asyncAssertFailure(error -> {
            if (this.msgVerifier != null) {
                this.msgVerifier.accept((Throwable)error);
            } else {
                ctx.assertEquals((Object)"Parameter at position[0] with class = [java.lang.String] and value = [1] can not be coerced to the expected class = [java.lang.Number] for encoding.", (Object)error.getMessage());
            }
        }))))));
    }

    @Test
    public void testPreparedQueryParamCoercionQuantityError(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", ""), ctx.asyncAssertSuccess(ps -> ps.query().execute(Tuple.of((Object)1, (Object)2), ctx.asyncAssertFailure(error -> {
            if (this.msgVerifier != null) {
                this.msgVerifier.accept((Throwable)error);
            } else {
                ctx.assertEquals((Object)"The number of parameters to execute should be consistent with the expected number of parameters = [1] but the actual number is [2].", (Object)error.getMessage());
            }
        }))))));
    }

    @Test
    public void testPreparedUpdate(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO mutable (id, val) VALUES (2, 'Whatever')").execute(ctx.asyncAssertSuccess(r1 -> {
            ctx.assertEquals((Object)1, (Object)r1.rowCount());
            conn.preparedQuery("UPDATE mutable SET val = 'Rocks!' WHERE id = 2").execute(ctx.asyncAssertSuccess(res1 -> {
                ctx.assertEquals((Object)1, (Object)res1.rowCount());
                conn.preparedQuery("SELECT val FROM mutable WHERE id = 2").execute(ctx.asyncAssertSuccess(res2 -> {
                    ctx.assertEquals((Object)"Rocks!", ((Row)res2.iterator().next()).getValue(0));
                    conn.close();
                }));
            }));
        }))));
    }

    @Test
    public void testPreparedUpdateWithParams(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO mutable (id, val) VALUES (2, 'Whatever')").execute(ctx.asyncAssertSuccess(r1 -> {
            ctx.assertEquals((Object)1, (Object)r1.rowCount());
            conn.preparedQuery(this.statement("UPDATE mutable SET val = ", " WHERE id = ", "")).execute(Tuple.of((Object)"Rocks Again!!", (Object)2), ctx.asyncAssertSuccess(res1 -> {
                ctx.assertEquals((Object)1, (Object)res1.rowCount());
                conn.preparedQuery(this.statement("SELECT val FROM mutable WHERE id = ", "")).execute(Tuple.of((Object)2), ctx.asyncAssertSuccess(res2 -> {
                    ctx.assertEquals((Object)"Rocks Again!!", ((Row)res2.iterator().next()).getValue(0));
                    conn.close();
                }));
            }));
        }))));
    }

    @Test
    public void testPreparedUpdateWithNullParams(TestContext ctx) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("INSERT INTO mutable (val, id) VALUES (", ",", ")")).execute(Tuple.of(null, (Object)1), ctx.asyncAssertFailure(error -> {
            if (this.msgVerifier != null) {
                this.msgVerifier.accept((Throwable)error);
            }
        }))));
    }

    private void testCursor(TestContext ctx, Handler<SqlConnection> test) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            if (this.cursorRequiresTx()) {
                conn.query("BEGIN").execute(ctx.asyncAssertSuccess(begin -> test.handle(conn)));
            } else {
                test.handle(conn);
            }
        }));
    }

    @Test
    public void testQueryCursor(TestContext ctx) {
        Async async = ctx.async();
        this.testCursor(ctx, (Handler<SqlConnection>)((Handler)conn -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", " OR id=", " OR id=", " OR id=", " OR id=", " OR id=", ""), ctx.asyncAssertSuccess(ps -> {
            Cursor query = ps.cursor(Tuple.of((Object)1, (Object)8, (Object)4, (Object)11, (Object)2, (Object)9));
            query.read(4, ctx.asyncAssertSuccess(result -> {
                ctx.assertNotNull((Object)result.columnsNames());
                ctx.assertEquals((Object)4, (Object)result.size());
                ctx.assertTrue(query.hasMore());
                query.read(4, ctx.asyncAssertSuccess(result2 -> {
                    ctx.assertNotNull((Object)result2.columnsNames());
                    ctx.assertEquals((Object)2, (Object)result2.size());
                    ctx.assertFalse(query.hasMore());
                    async.complete();
                }));
            }));
        }))));
    }

    @Test
    public void testQueryCloseCursor(TestContext ctx) {
        Async async = ctx.async();
        this.testCursor(ctx, (Handler<SqlConnection>)((Handler)conn -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", " OR id=", " OR id=", " OR id=", " OR id=", " OR id=", ""), ctx.asyncAssertSuccess(ps -> {
            Cursor cursor = ps.cursor(Tuple.of((Object)1, (Object)8, (Object)4, (Object)11, (Object)2, (Object)9));
            cursor.read(4, ctx.asyncAssertSuccess(results -> {
                ctx.assertEquals((Object)4, (Object)results.size());
                cursor.close(ctx.asyncAssertSuccess(v1 -> {
                    ctx.assertTrue(cursor.isClosed());
                    ps.close(ctx.asyncAssertSuccess(v2 -> async.complete()));
                }));
            }));
        }))));
    }

    @Test
    public void testQueryStreamCloseCursor(TestContext ctx) {
        Async async = ctx.async();
        this.testCursor(ctx, (Handler<SqlConnection>)((Handler)conn -> conn.prepare(this.statement("SELECT * FROM immutable WHERE id=", " OR id=", " OR id=", " OR id=", " OR id=", " OR id=", ""), ctx.asyncAssertSuccess(ps -> {
            RowStream stream = ps.createStream(4, Tuple.of((Object)1, (Object)8, (Object)4, (Object)11, (Object)2, (Object)9));
            ArrayList rows = new ArrayList();
            stream.handler(row -> {
                rows.add(row);
                if (rows.size() == 4) {
                    Cursor cursor = ((RowStreamInternal)stream).cursor();
                    ctx.assertFalse(cursor.isClosed());
                    stream.close(ctx.asyncAssertSuccess(v1 -> {
                        ctx.assertTrue(cursor.isClosed());
                        ps.close(ctx.asyncAssertSuccess(v2 -> async.complete()));
                    }));
                }
            });
        }))));
    }

    @Test
    public void testStreamQuery(TestContext ctx) {
        Async async = ctx.async();
        this.testCursor(ctx, (Handler<SqlConnection>)((Handler)conn -> conn.prepare("SELECT * FROM immutable", ctx.asyncAssertSuccess(ps -> {
            RowStream stream = ps.createStream(4, Tuple.tuple());
            ArrayList rows = new ArrayList();
            AtomicInteger ended = new AtomicInteger();
            stream.handler(tuple -> {
                ctx.assertEquals((Object)0, (Object)ended.get());
                rows.add(tuple);
            });
            Cursor cursor = ((RowStreamInternal)stream).cursor();
            stream.endHandler(v -> {
                ctx.assertTrue(cursor.isClosed());
                ctx.assertEquals((Object)0, (Object)ended.getAndIncrement());
                ctx.assertEquals((Object)12, (Object)rows.size());
                async.complete();
            });
        }))));
    }

    @Test
    public void testStreamQueryPauseInBatch(TestContext ctx) {
        this.testStreamQueryPauseInBatch(ctx, Runnable::run);
    }

    @Test
    public void testStreamQueryPauseInBatchFromAnotherThread(TestContext ctx) {
        this.testStreamQueryPauseInBatch(ctx, t -> new Thread(t).start());
    }

    private void testStreamQueryPauseInBatch(TestContext ctx, Executor executor) {
        Async async = ctx.async();
        this.testCursor(ctx, (Handler<SqlConnection>)((Handler)conn -> conn.prepare("SELECT * FROM immutable", ctx.asyncAssertSuccess(ps -> {
            RowStream stream = ps.createStream(4, Tuple.tuple());
            List rows = Collections.synchronizedList(new ArrayList());
            AtomicInteger ended = new AtomicInteger();
            executor.execute(() -> {
                stream.endHandler(v -> {
                    ctx.assertEquals((Object)0, (Object)ended.getAndIncrement());
                    ctx.assertEquals((Object)12, (Object)rows.size());
                    async.complete();
                });
                stream.handler(tuple -> {
                    rows.add(tuple);
                    if (rows.size() == 2) {
                        stream.pause();
                        executor.execute(() -> this.vertx.setTimer(100L, v -> executor.execute(() -> ((RowStream)stream).resume())));
                    }
                });
            });
        }))));
    }

    @Test
    public void testStreamQueryPauseResume(TestContext ctx) {
        Async async = ctx.async();
        this.testCursor(ctx, (Handler<SqlConnection>)((Handler)conn -> conn.prepare("SELECT * FROM immutable", ctx.asyncAssertSuccess(ps -> {
            RowStream stream = ps.createStream(4, Tuple.tuple());
            ArrayList rows = new ArrayList();
            AtomicInteger ended = new AtomicInteger();
            stream.handler(tuple -> {
                ctx.assertEquals((Object)0, (Object)ended.get());
                rows.add(tuple);
            });
            stream.pause();
            stream.resume();
            stream.endHandler(v -> async.complete());
        }))));
    }

    protected void cleanTestTable(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("TRUNCATE TABLE mutable").execute(ctx.asyncAssertSuccess(result -> conn.close()))));
    }
}

