/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.tck.Connector;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class PipeliningQueryTestBase {
    protected Vertx vertx;
    protected SqlConnectOptions options;
    AtomicInteger orderCheckCounter;
    protected Connector<SqlConnection> connectionConnector;
    protected Connector<SqlConnection> pooledConnectionConnector;
    protected Supplier<SqlClient> pooledClientSupplier;

    @Before
    public void setup(TestContext ctx) {
        this.vertx = Vertx.vertx();
        this.init();
        this.orderCheckCounter = new AtomicInteger(0);
        this.cleanTestTable(ctx);
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected abstract void init();

    protected abstract String statement(String ... var1);

    protected String buildCounterPreparedQueryWithoutTable() {
        return this.statement("SELECT ", "");
    }

    @Test
    public void testContinuousSimpleQueryUsingConn(TestContext ctx) {
        this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> this.testSequentialQueryWithConnection(ctx, currentIter -> conn.query("SELECT " + currentIter).execute())));
    }

    @Test
    public void testContinuousSimpleQueryUsingPoolWithSingleConn(TestContext ctx) {
        this.pooledConnectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(pooledConn -> this.testSequentialQueryWithConnection(ctx, currentIter -> pooledConn.query("SELECT " + currentIter).execute())));
    }

    @Test
    public void testContinuousSimpleQueryUsingPool(TestContext ctx) {
        SqlClient client = this.pooledClientSupplier.get();
        this.testQueryWithPool(ctx, currentIter -> client.query("SELECT " + currentIter).execute());
    }

    @Test
    public void testContinuousOneShotPreparedQueryUsingConn(TestContext ctx) {
        this.options.setCachePreparedStatements(false);
        this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> this.testSequentialQueryWithConnection(ctx, currentIter -> conn.preparedQuery("SELECT " + currentIter).execute())));
    }

    @Test
    public void testContinuousOneShotPreparedQueryUsingPoolWithSingleConn(TestContext ctx) {
        this.options.setCachePreparedStatements(false);
        this.pooledConnectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(pooledConn -> this.testSequentialQueryWithConnection(ctx, currentIter -> pooledConn.preparedQuery("SELECT " + currentIter).execute())));
    }

    @Test
    public void testContinuousOneShotPreparedQueryUsingPool(TestContext ctx) {
        this.options.setCachePreparedStatements(false);
        SqlClient client = this.pooledClientSupplier.get();
        this.testQueryWithPool(ctx, currentIter -> client.preparedQuery("SELECT " + currentIter).execute());
    }

    @Test
    public void testContinuousOneShotCachedPreparedQueryWithSameSqlUsingConn(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> this.testSequentialQueryWithConnection(ctx, currentIter -> conn.preparedQuery(this.buildCounterPreparedQueryWithoutTable()).execute(Tuple.of((Object)currentIter)))));
    }

    @Test
    public void testContinuousOneShotCachedPreparedQueryWithSameSqlUsingPoolWithSingleConn(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        this.pooledConnectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(pooledConn -> this.testSequentialQueryWithConnection(ctx, currentIter -> pooledConn.preparedQuery(this.buildCounterPreparedQueryWithoutTable()).execute(Tuple.of((Object)currentIter)))));
    }

    @Test
    public void testContinuousOneShotCachedPreparedQueryWithSameSqlUsingPool(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        SqlClient client = this.pooledClientSupplier.get();
        this.testQueryWithPool(ctx, currentIter -> client.preparedQuery(this.buildCounterPreparedQueryWithoutTable()).execute(Tuple.of((Object)currentIter)));
    }

    @Test
    public void testContinuousOneShotCachedPreparedQueryWithDifferentSqlUsingConn(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> this.testSequentialQueryWithConnection(ctx, currentIter -> conn.preparedQuery("SELECT " + currentIter).execute())));
    }

    @Test
    public void testContinuousOneShotCachedPreparedQueryWithDifferentSqlUsingPoolWithSingleConn(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        this.pooledConnectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(pooledConn -> this.testSequentialQueryWithConnection(ctx, currentIter -> pooledConn.preparedQuery("SELECT " + currentIter).execute())));
    }

    @Test
    public void testContinuousOneShotCachedPreparedQueryWithDifferentSqlUsingPool(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        SqlClient client = this.pooledClientSupplier.get();
        this.testQueryWithPool(ctx, currentIter -> client.preparedQuery("SELECT " + currentIter).execute());
    }

    @Test
    public void testPrepareAndExecuteWithDifferentSql(TestContext ctx) {
        this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            Async latch = ctx.async(1000);
            int i = 0;
            while (i < 1000) {
                int currentIter = i++;
                conn.prepare("SELECT " + currentIter).onComplete(ctx.asyncAssertSuccess(ps -> ps.query().execute().onComplete(ctx.asyncAssertSuccess(res -> {
                    this.checkSequentialQueryResult(ctx, (RowSet<Row>)res, currentIter, this.orderCheckCounter);
                    ps.close(ctx.asyncAssertSuccess(v -> latch.countDown()));
                }))));
            }
        }));
    }

    @Test
    public void testOneShotPreparedBatchQueryConn(TestContext ctx) {
        this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> this.testOneShotPreparedBatchQuery(ctx, (SqlClient)conn)));
    }

    @Test
    public void testOneShotPreparedBatchQueryPool(TestContext ctx) {
        SqlClient client = this.pooledClientSupplier.get();
        this.testOneShotPreparedBatchQuery(ctx, client);
    }

    private void testOneShotPreparedBatchQuery(TestContext ctx, SqlClient client) {
        ArrayList<Tuple> batchParams = new ArrayList<Tuple>();
        Async latch = ctx.async(1000);
        for (int i = 0; i < 1000; ++i) {
            batchParams.add(Tuple.of((Object)i));
        }
        client.preparedQuery(this.buildCounterPreparedQueryWithoutTable()).executeBatch(batchParams).onComplete(ctx.asyncAssertSuccess(res -> {
            for (int i = 0; i < 1000; ++i) {
                ctx.assertEquals((Object)1, (Object)res.size());
                Row row = (Row)res.iterator().next();
                ctx.assertEquals((Object)1, (Object)row.size());
                ctx.assertEquals((Object)i, (Object)row.getInteger(0));
                latch.countDown();
                res = res.next();
            }
            client.close();
        }));
    }

    @Test
    public void testOneShotPreparedBatchInsertConn(TestContext ctx) {
        this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> this.testOneShotPreparedBatchInsert(ctx, (SqlClient)conn)));
    }

    @Test
    public void testOneShotPreparedBatchInsertPool(TestContext ctx) {
        SqlClient client = this.pooledClientSupplier.get();
        this.testOneShotPreparedBatchInsert(ctx, client);
    }

    private void testOneShotPreparedBatchInsert(TestContext ctx, SqlClient client) {
        Async latch = ctx.async(1000);
        ArrayList<Tuple> batchParams = new ArrayList<Tuple>();
        for (int i = 0; i < 1000; ++i) {
            batchParams.add(Tuple.of((Object)i, (Object)String.format("val-%d", i)));
        }
        client.preparedQuery(this.statement("INSERT INTO mutable(id, val) VALUES (", ", ", ")")).executeBatch(batchParams).onComplete(ctx.asyncAssertSuccess(res -> {
            for (int i = 0; i < 1000; ++i) {
                ctx.assertEquals((Object)1, (Object)res.rowCount());
                res = res.next();
                latch.countDown();
            }
            client.query("SELECT id, val FROM mutable").execute().onComplete(ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)1000, (Object)res2.size());
                int i = 0;
                for (Row row : res2) {
                    ctx.assertEquals((Object)2, (Object)row.size());
                    ctx.assertEquals((Object)i, (Object)row.getInteger(0));
                    ctx.assertEquals((Object)String.format("val-%d", i), (Object)row.getString(1));
                    ++i;
                }
                client.close();
            }));
        }));
    }

    private void cleanTestTable(TestContext ctx) {
        this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("TRUNCATE TABLE mutable;").execute(ctx.asyncAssertSuccess(result -> conn.close()))));
    }

    private void testSequentialQueryWithConnection(TestContext ctx, Function<Integer, Future<RowSet<Row>>> resultExecution) {
        Async latch = ctx.async(1000);
        int i = 0;
        while (i < 1000) {
            int currentIter = i++;
            resultExecution.apply(currentIter).onComplete(ctx.asyncAssertSuccess(res -> {
                this.checkSequentialQueryResult(ctx, (RowSet<Row>)res, currentIter, this.orderCheckCounter);
                latch.countDown();
            }));
        }
    }

    private void testQueryWithPool(TestContext ctx, Function<Integer, Future<RowSet<Row>>> resultExecution) {
        Async latch = ctx.async(1000);
        int i = 0;
        while (i < 1000) {
            int currentIter = i++;
            resultExecution.apply(currentIter).onComplete(ctx.asyncAssertSuccess(res -> {
                this.checkQueryResult(ctx, (RowSet<Row>)res, currentIter);
                latch.countDown();
            }));
        }
    }

    private void checkSequentialQueryResult(TestContext ctx, RowSet<Row> result, int currentIter, AtomicInteger orderCheckCounter) {
        ctx.assertEquals((Object)1, (Object)result.size());
        Row row = (Row)result.iterator().next();
        ctx.assertEquals((Object)1, (Object)row.size());
        ctx.assertEquals((Object)currentIter, (Object)row.getInteger(0));
        ctx.assertEquals((Object)currentIter, (Object)orderCheckCounter.getAndIncrement());
    }

    private void checkQueryResult(TestContext ctx, RowSet<Row> result, int currentIter) {
        ctx.assertEquals((Object)1, (Object)result.size());
        Row row = (Row)result.iterator().next();
        ctx.assertEquals((Object)1, (Object)row.size());
        ctx.assertEquals((Object)currentIter, (Object)row.getInteger(0));
    }
}

