/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.NullValue;
import io.vertx.sqlclient.tck.Connector;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class NullValueEncodeTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    protected abstract void initConnector();

    @Before
    public void setup(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.connector.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testEncodeNullBoolean(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.Boolean);
    }

    @Test
    public void testEncodeNullShort(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.Short);
    }

    @Test
    public void testEncodeNullInteger(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.Integer);
    }

    @Test
    public void testEncodeNullLong(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.Long);
    }

    @Test
    public void testEncodeNullFloat(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.Float);
    }

    @Test
    public void testEncodeNullDouble(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.Double);
    }

    @Test
    public void testEncodeNullString(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.String);
    }

    @Test
    public void testEncodeNullJsonObject(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.JsonObject);
    }

    @Test
    public void testEncodeNullJsonArray(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.JsonArray);
    }

    @Test
    public void testEncodeNullTemporal(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.Temporal);
    }

    @Test
    public void testEncodeNullLocalDate(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.LocalDate);
    }

    @Test
    public void testEncodeNullLocalTime(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.LocalTime);
    }

    @Test
    public void testEncodeNullLocalDateTime(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.LocalDateTime);
    }

    @Test
    public void testEncodeNullOffsetTime(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.OffsetTime);
    }

    @Test
    public void testEncodeNullOffsetDateTime(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.OffsetDateTime);
    }

    @Test
    public void testEncodeNullBuffer(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.Buffer);
    }

    @Test
    public void testEncodeNullUUID(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.UUID);
    }

    @Test
    public void testEncodeNullBigDecimal(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.BigDecimal);
    }

    @Test
    public void testEncodeNullArrayOfBoolean(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfBoolean);
    }

    @Test
    public void testEncodeNullArrayOfShort(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfShort);
    }

    @Test
    public void testEncodeNullArrayOfInteger(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfInteger);
    }

    @Test
    public void testEncodeNullArrayOfLong(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfLong);
    }

    @Test
    public void testEncodeNullArrayOfFloat(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfFloat);
    }

    @Test
    public void testEncodeNullArrayOfDouble(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfDouble);
    }

    @Test
    public void testEncodeNullArrayOfString(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfString);
    }

    @Test
    public void testEncodeNullArrayOfJsonObject(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfJsonObject);
    }

    @Test
    public void testEncodeNullArrayOfJsonArray(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfJsonArray);
    }

    @Test
    public void testEncodeNullArrayOfTemporal(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfTemporal);
    }

    @Test
    public void testEncodeNullArrayOfLocalDate(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfLocalDate);
    }

    @Test
    public void testEncodeNullArrayOfLocalTime(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfLocalTime);
    }

    @Test
    public void testEncodeNullArrayOfLocalDateTime(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfLocalDateTime);
    }

    @Test
    public void testEncodeNullArrayOfOffsetTime(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfOffsetTime);
    }

    @Test
    public void testEncodeNullArrayOfOffsetDateTime(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfOffsetDateTime);
    }

    @Test
    public void testEncodeNullArrayOfBuffer(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfBuffer);
    }

    @Test
    public void testEncodeNullArrayOfUUID(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfUUID);
    }

    @Test
    public void testEncodeNullArrayOfBigDecimal(TestContext ctx) {
        this.testEncodeNull(ctx, NullValue.ArrayOfBigDecimal);
    }

    private void testEncodeNull(TestContext ctx, NullValue nullValue) {
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            Tuple.tuple();
            conn.preparedQuery(this.statement("SELECT ", "")).execute(Tuple.of((Object)nullValue), ctx.asyncAssertSuccess(rs -> {
                Row row = (Row)rs.iterator().next();
                ctx.assertNull(row.getValue(0));
            }));
        }));
    }

    protected abstract String statement(String ... var1);
}

