/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import io.vertx.sqlclient.tck.Connector;
import java.sql.JDBCType;
import org.junit.After;
import org.junit.Before;

public abstract class DataTypeTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;

    protected abstract JDBCType getNumericJDBCType();

    protected abstract Class<? extends Number> getNumericClass();

    protected abstract Number getNumericValue(Number var1);

    protected abstract Number getNumericValue(String var1);

    protected abstract void initConnector();

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    @Before
    public void setUp(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.connector.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected void verifyTypeName(TestContext ctx, ColumnDescriptor columnDescriptor) {
        ctx.assertNotNull((Object)columnDescriptor);
    }
}

