/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public abstract class ConnectionAutoRetryTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connectionConnector;
    protected Connector<SqlConnection> poolConnector;
    protected SqlConnectOptions options;

    @Before
    public void setUp() throws Exception {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected abstract void initialConnector(int var1);

    @Test
    public void testConnSuccessWithoutRetry(TestContext ctx) {
        this.options.setReconnectAttempts(3);
        this.options.setReconnectInterval(1000L);
        UnstableProxyServer unstableProxyServer = new UnstableProxyServer(0);
        unstableProxyServer.initialize(this.options, (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v -> {
            this.initialConnector(unstableProxyServer.port());
            this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.close()));
        }));
    }

    @Test
    public void testPoolSuccessWithoutRetry(TestContext ctx) {
        this.options.setReconnectAttempts(3);
        this.options.setReconnectInterval(1000L);
        UnstableProxyServer unstableProxyServer = new UnstableProxyServer(0);
        unstableProxyServer.initialize(this.options, (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v -> {
            this.initialConnector(unstableProxyServer.port());
            this.poolConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.close()));
        }));
    }

    @Test
    public void testConnExceedingRetryLimit(TestContext ctx) {
        this.options.setReconnectAttempts(1);
        this.options.setReconnectInterval(1000L);
        UnstableProxyServer unstableProxyServer = new UnstableProxyServer(2);
        unstableProxyServer.initialize(this.options, (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v -> {
            this.initialConnector(unstableProxyServer.port());
            this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertFailure(throwable -> {}));
        }));
    }

    @Test
    public void testPoolExceedingRetryLimit(TestContext ctx) {
        this.options.setReconnectAttempts(1);
        this.options.setReconnectInterval(1000L);
        UnstableProxyServer unstableProxyServer = new UnstableProxyServer(2);
        unstableProxyServer.initialize(this.options, (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v -> {
            this.initialConnector(unstableProxyServer.port());
            this.poolConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertFailure(throwable -> {}));
        }));
    }

    @Test
    public void testConnRetrySuccess(TestContext ctx) {
        this.options.setReconnectAttempts(1);
        this.options.setReconnectInterval(1000L);
        UnstableProxyServer unstableProxyServer = new UnstableProxyServer(1);
        unstableProxyServer.initialize(this.options, (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v -> {
            this.initialConnector(unstableProxyServer.port());
            this.connectionConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(connection -> connection.close()));
        }));
    }

    @Test
    public void testPoolRetrySuccess(TestContext ctx) {
        this.options.setReconnectAttempts(1);
        this.options.setReconnectInterval(1000L);
        UnstableProxyServer unstableProxyServer = new UnstableProxyServer(1);
        unstableProxyServer.initialize(this.options, (Handler<AsyncResult<Void>>)ctx.asyncAssertSuccess(v -> {
            this.initialConnector(unstableProxyServer.port());
            this.poolConnector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.close()));
        }));
    }

    public class UnstableProxyServer {
        private final Logger LOGGER = LoggerFactory.getLogger(UnstableProxyServer.class);
        private NetServer netServer;
        private NetClient netClient;
        private int retryTimes;
        private AtomicInteger counter;
        private Map<NetSocket, Queue<Buffer>> bufferedOutboundFrontendRequest = new HashMap<NetSocket, Queue<Buffer>>();
        private Map<NetSocket, NetSocket> frontendSocketToBackendSocket = new HashMap<NetSocket, NetSocket>();

        public UnstableProxyServer(int retryTimes) {
            this.retryTimes = retryTimes;
            this.counter = new AtomicInteger(retryTimes);
        }

        public void initialize(SqlConnectOptions targetOptions, Handler<AsyncResult<Void>> resultHandler) {
            this.netClient = ConnectionAutoRetryTestBase.this.vertx.createNetClient();
            this.netServer = ConnectionAutoRetryTestBase.this.vertx.createNetServer().connectHandler(frontendSocket -> {
                this.LOGGER.info((Object)"Proxy: frontend socket connected");
                frontendSocket.handler(outbound -> {
                    NetSocket backendSocket = this.frontendSocketToBackendSocket.get(frontendSocket);
                    if (backendSocket == null) {
                        this.bufferFrontendRequest((NetSocket)frontendSocket, (Buffer)outbound);
                    } else {
                        this.sendBufferedFrontendRequest((NetSocket)frontendSocket, backendSocket);
                        backendSocket.write(outbound);
                    }
                });
                if (this.counter.getAndDecrement() > 0) {
                    this.LOGGER.info((Object)"Proxy: frontend socket closed by proxy");
                    frontendSocket.close();
                } else {
                    this.netClient.connect(targetOptions.getPort(), targetOptions.getHost()).onSuccess(backendSocket -> {
                        this.LOGGER.info((Object)"Proxy: backend socket connected");
                        this.frontendSocketToBackendSocket.put((NetSocket)frontendSocket, (NetSocket)backendSocket);
                        backendSocket.handler(in -> frontendSocket.write(in));
                        this.sendBufferedFrontendRequest((NetSocket)frontendSocket, (NetSocket)backendSocket);
                    }).onFailure(t -> {
                        this.LOGGER.error((Object)"Proxy: backend socket connect failure");
                        this.netClient.close();
                    });
                }
            });
            this.netServer.listen().onComplete(ar -> {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture());
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            });
        }

        public int port() {
            return this.netServer.actualPort();
        }

        public int token() {
            return this.counter.get();
        }

        public void reset() {
            this.counter.set(this.retryTimes);
        }

        private void bufferFrontendRequest(NetSocket frontendSocket, Buffer request) {
            Queue<Buffer> bufferQueue = this.bufferedOutboundFrontendRequest.get(frontendSocket);
            if (bufferQueue == null) {
                bufferQueue = new ArrayDeque<Buffer>();
                bufferQueue.add(request);
                this.bufferedOutboundFrontendRequest.put(frontendSocket, bufferQueue);
            } else {
                bufferQueue.add(request);
            }
        }

        private void sendBufferedFrontendRequest(NetSocket frontendSocket, NetSocket backendSocket) {
            Queue<Buffer> bufferQueue = this.bufferedOutboundFrontendRequest.get(frontendSocket);
            if (bufferQueue != null) {
                Buffer bufferedOutbound;
                while ((bufferedOutbound = bufferQueue.poll()) != null) {
                    this.frontendSocketToBackendSocket.get(frontendSocket).write((Object)bufferedOutbound);
                }
            }
        }
    }
}

