/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.tck.DataTypeTestBase;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.function.BiFunction;
import org.junit.Test;

public abstract class BinaryDataTypeEncodeTestBase
extends DataTypeTestBase {
    protected abstract String statement(String ... var1);

    @Test
    public void testSmallInt(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_int_2", Short.class, Row::getShort, (short)Short.MIN_VALUE);
    }

    @Test
    public void testInteger(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_int_4", Integer.class, Row::getInteger, Integer.MIN_VALUE);
    }

    @Test
    public void testBigInt(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_int_8", Long.class, Row::getLong, Long.MIN_VALUE);
    }

    @Test
    public void testFloat4(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_float_4", Float.class, Row::getFloat, Float.valueOf(-3.402823E38f));
    }

    @Test
    public void testDouble(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_float_8", Double.class, Row::getDouble, Double.MIN_VALUE);
    }

    @Test
    public void testNumeric(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_numeric", this.getNumericClass(), null, this.getNumericValue("-999.99"));
    }

    @Test
    public void testDecimal(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_decimal", this.getNumericClass(), null, this.getNumericValue("-12345"));
    }

    @Test
    public void testChar(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_char", String.class, Row::getString, "newchar0");
    }

    @Test
    public void testVarchar(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_varchar", String.class, Row::getString, "newvarchar");
    }

    @Test
    public void testBoolean(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_boolean", Boolean.class, Row::getBoolean, false);
    }

    @Test
    public void testDate(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_date", LocalDate.class, Row::getLocalDate, LocalDate.parse("1999-12-31"));
    }

    @Test
    public void testTime(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_time", LocalTime.class, Row::getLocalTime, LocalTime.of(12, 1, 30));
    }

    @Test
    public void testNullValues(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("UPDATE basicdatatype SET test_int_2 = ", ", test_int_4 = ", ", test_int_8 = ", ", test_float_4 = ", ", test_float_8 = ", ", test_numeric = ", ", test_decimal = ", ", test_boolean = ", ", test_char = ", ", test_varchar = ", ", test_date = ", ", test_time = ", " WHERE id = 2")).execute(Tuple.tuple().addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null), ctx.asyncAssertSuccess(updateResult -> conn.preparedQuery("SELECT * FROM basicdatatype WHERE id = 2").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)13, (Object)row.size());
            ctx.assertEquals((Object)2, (Object)row.getInteger(0));
            for (int i = 1; i < 13; ++i) {
                ctx.assertNull(row.getValue(i));
            }
            conn.close();
        }))))));
    }

    protected <T> void testEncodeGeneric(TestContext ctx, String columnName, Class<? extends T> clazz, BiFunction<Row, String, T> getter, T expected) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery(this.statement("UPDATE basicdatatype SET " + columnName + " = ", " WHERE id = 2")).execute(Tuple.tuple().addValue(expected), ctx.asyncAssertSuccess(updateResult -> conn.preparedQuery("SELECT " + columnName + " FROM basicdatatype WHERE id = 2").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.size());
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
            if (getter != null) {
                ctx.assertEquals(expected, getter.apply(row, columnName));
            }
            conn.close();
        }))))));
    }
}

