/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import io.vertx.sqlclient.tck.DataTypeTestBase;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalTime;
import org.junit.Test;

public abstract class BinaryDataTypeDecodeTestBase
extends DataTypeTestBase {
    @Test
    public void testSmallInt(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_2", Short.class, JDBCType.SMALLINT, (short)Short.MAX_VALUE);
    }

    @Test
    public void testInteger(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_4", Integer.class, JDBCType.INTEGER, Integer.MAX_VALUE);
    }

    @Test
    public void testBigInt(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_int_8", Long.class, JDBCType.BIGINT, Long.MAX_VALUE);
    }

    @Test
    public void testFloat4(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_float_4", Float.class, JDBCType.REAL, Float.valueOf(3.40282E38f));
    }

    @Test
    public void testDouble(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_float_8", Double.class, JDBCType.DOUBLE, Double.MAX_VALUE);
    }

    @Test
    public void testNumeric(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_numeric", this.getNumericClass(), this.getNumericJDBCType(), this.getNumericValue("999.99"));
    }

    @Test
    public void testDecimal(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_decimal", this.getNumericClass(), this.getNumericJDBCType(), this.getNumericValue("12345"));
    }

    @Test
    public void testBoolean(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_boolean", Boolean.class, JDBCType.BOOLEAN, true);
    }

    @Test
    public void testChar(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_char", String.class, JDBCType.VARCHAR, "testchar");
    }

    @Test
    public void testVarchar(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_varchar", String.class, JDBCType.VARCHAR, "testvarchar");
    }

    @Test
    public void testDate(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_date", LocalDate.class, JDBCType.DATE, LocalDate.of(2019, 1, 1));
    }

    @Test
    public void testTime(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_time", LocalTime.class, JDBCType.TIME, LocalTime.of(18, 45, 2));
    }

    protected <T> void testDecodeGeneric(TestContext ctx, String columnName, Class<? extends T> clazz, JDBCType jdbcType, T expected) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT " + columnName + " FROM basicdatatype WHERE id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
            ColumnDescriptor columnDescriptor = (ColumnDescriptor)result.columnDescriptors().get(0);
            ctx.assertEquals((Object)jdbcType, (Object)columnDescriptor.jdbcType());
            this.verifyTypeName(ctx, columnDescriptor);
            conn.close();
        }))));
    }

    @Test
    public void testNullValues(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT test_int_2,test_int_4,test_int_8,test_float_4,test_float_8,test_numeric,test_decimal,test_boolean,test_char,test_varchar,test_date,test_time from basicdatatype where id = 3").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)12, (Object)row.size());
            for (int i = 0; i < 12; ++i) {
                ctx.assertNull(row.getValue(i));
            }
            conn.close();
        }))));
    }

    @Test
    public void testSelectAll(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT test_int_2,test_int_4,test_int_8,test_float_4,test_float_8,test_numeric,test_decimal,test_boolean,test_char,test_varchar,test_date,test_time from basicdatatype where id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)12, (Object)row.size());
            ctx.assertEquals((Object)Short.MAX_VALUE, (Object)row.getShort(0));
            ctx.assertEquals((Object)Short.MAX_VALUE, (Object)row.getShort("test_int_2"));
            ctx.assertEquals((Object)Integer.MAX_VALUE, (Object)row.getInteger(1));
            ctx.assertEquals((Object)Integer.MAX_VALUE, (Object)row.getInteger("test_int_4"));
            ctx.assertEquals((Object)Long.MAX_VALUE, (Object)row.getLong(2));
            ctx.assertEquals((Object)Long.MAX_VALUE, (Object)row.getLong("test_int_8"));
            ctx.assertEquals((Object)Float.valueOf(3.40282E38f), (Object)row.getFloat(3));
            ctx.assertEquals((Object)Float.valueOf(3.40282E38f), (Object)row.getFloat("test_float_4"));
            ctx.assertEquals((Object)Double.MAX_VALUE, (Object)row.getDouble(4));
            ctx.assertEquals((Object)Double.MAX_VALUE, (Object)row.getDouble("test_float_8"));
            ctx.assertEquals((Object)this.getNumericValue(999.99), row.get(this.getNumericClass(), 5));
            ctx.assertEquals((Object)this.getNumericValue(999.99), row.getValue("test_numeric"));
            ctx.assertEquals((Object)this.getNumericValue(12345), row.get(this.getNumericClass(), 6));
            ctx.assertEquals((Object)this.getNumericValue(12345), row.getValue("test_decimal"));
            ctx.assertEquals((Object)true, (Object)row.getBoolean(7));
            ctx.assertEquals((Object)true, (Object)row.getBoolean("test_boolean"));
            ctx.assertEquals((Object)"testchar", (Object)row.getString(8));
            ctx.assertEquals((Object)"testchar", (Object)row.getString("test_char"));
            ctx.assertEquals((Object)"testvarchar", (Object)row.getString(9));
            ctx.assertEquals((Object)"testvarchar", (Object)row.getString("test_varchar"));
            ctx.assertEquals((Object)LocalDate.parse("2019-01-01"), row.getValue(10));
            ctx.assertEquals((Object)LocalDate.parse("2019-01-01"), row.getValue("test_date"));
            ctx.assertEquals((Object)LocalTime.parse("18:45:02"), row.getValue(11));
            ctx.assertEquals((Object)LocalTime.parse("18:45:02"), row.getValue("test_time"));
            conn.close();
        }))));
    }

    @Test
    public void testToJsonObject(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT test_int_2,test_int_4,test_int_8,test_float_4,test_float_8,test_numeric,test_decimal,test_boolean,test_char,test_varchar,test_date from basicdatatype where id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            JsonObject json = row.toJson();
            ctx.assertEquals((Object)11, (Object)json.size());
            ctx.assertEquals((Object)Short.MAX_VALUE, json.getValue("test_int_2"));
            ctx.assertEquals((Object)Integer.MAX_VALUE, json.getValue("test_int_4"));
            ctx.assertEquals((Object)Long.MAX_VALUE, json.getValue("test_int_8"));
            ctx.assertEquals((Object)Float.valueOf(3.40282E38f), json.getValue("test_float_4"));
            ctx.assertEquals((Object)Double.MAX_VALUE, json.getValue("test_float_8"));
            ctx.assertEquals((Object)this.getNumericValue(999.99), json.getValue("test_numeric"));
            ctx.assertEquals((Object)this.getNumericValue(12345), json.getValue("test_decimal"));
            Object booleanValue = json.getValue("test_boolean");
            ctx.assertTrue(booleanValue instanceof Boolean || booleanValue instanceof Number);
            ctx.assertEquals((Object)"testchar", json.getValue("test_char"));
            ctx.assertEquals((Object)"testvarchar", json.getValue("test_varchar"));
            ctx.assertEquals((Object)"2019-01-01", json.getValue("test_date"));
            conn.close();
        }))));
    }
}

