/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.accumulator;

import io.vertx.sqlclient.impl.accumulator.ArrayListRowAccumulator;
import io.vertx.sqlclient.impl.accumulator.ChunkedRowAccumulator;
import io.vertx.sqlclient.impl.accumulator.RowAccumulator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RowAccumulatorTest {
    private final List<String> data;

    @Parameterized.Parameters(name="Accumulate {index} item(s)")
    public static List<Object[]> testData() {
        return new AbstractList<Object[]>(){

            @Override
            public Object[] get(int index) {
                switch (index) {
                    case 0: {
                        return new Object[]{Collections.emptyList()};
                    }
                    case 1: {
                        return new Object[]{Collections.singletonList(UUID.randomUUID().toString())};
                    }
                }
                return new Object[]{IntStream.range(0, index).mapToObj(i -> UUID.randomUUID().toString()).collect(Collectors.toList())};
            }

            @Override
            public int size() {
                return 1000;
            }
        };
    }

    public RowAccumulatorTest(List<String> data) {
        this.data = data;
    }

    @Test
    public void testArrayListAccumulator() {
        this.doTest((RowAccumulator<String>)new ArrayListRowAccumulator());
    }

    private void doTest(RowAccumulator<String> rowAccumulator) {
        this.data.forEach(rowAccumulator);
        ArrayList<String> actual = new ArrayList<String>(this.data.size());
        for (String value : rowAccumulator) {
            actual.add(value);
        }
        Assert.assertEquals(this.data, actual);
    }

    @Test
    public void testChunkedAccumulatorFixedChunkSize() {
        this.doTest((RowAccumulator<String>)new ChunkedRowAccumulator(IntUnaryOperator.identity()));
    }

    @Test
    public void testChunkedAccumulatorGrowingChunkSize() {
        this.doTest((RowAccumulator<String>)new ChunkedRowAccumulator(size -> size + (size >> 1)));
    }
}

