/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.impl.PropertyKindMap;
import io.vertx.sqlclient.impl.RowSetImpl;
import org.junit.Assert;
import org.junit.Test;

public class SqlResultTest {
    @Test
    public void testNullPropertyKind() {
        RowSetImpl rowSet = new RowSetImpl();
        try {
            rowSet.property(null);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Property can not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testNullProperties() {
        RowSetImpl rowSet = new RowSetImpl();
        rowSet.properties = null;
        PropertyKind propertyKind = PropertyKind.create((String)"test", String.class);
        Assert.assertNull((Object)rowSet.property(propertyKind));
    }

    @Test
    public void testPropertyKindNullType() {
        RowSetImpl rowSet = new RowSetImpl();
        rowSet.properties = new PropertyKindMap();
        PropertyKind<String> nullTypePropertyKind = new PropertyKind<String>(){

            public String name() {
                return "test";
            }

            public Class<String> type() {
                return null;
            }
        };
        try {
            rowSet.property((PropertyKind)nullTypePropertyKind);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testUnknownPropertyKind() {
        RowSetImpl rowSet = new RowSetImpl();
        PropertyKind knownPropertyKind = PropertyKind.create((String)"test-1", Integer.class);
        PropertyKind unknownPropertyKind = PropertyKind.create((String)"test-2", String.class);
        rowSet.properties = new PropertyKindMap();
        rowSet.properties.put(knownPropertyKind, (Object)1234);
        Assert.assertEquals((Object)1234, (Object)rowSet.property(knownPropertyKind));
        Assert.assertNull((Object)rowSet.property(unknownPropertyKind));
    }

    @Test
    public void testInvalidPropertyType() {
        RowSetImpl rowSet = new RowSetImpl();
        PropertyKind propertyKind1 = PropertyKind.create((String)"test", Integer.class);
        PropertyKind propertyKind2 = PropertyKind.create((String)"test", String.class);
        rowSet.properties = new PropertyKindMap();
        rowSet.properties.put(propertyKind1, (Object)1234);
        Assert.assertEquals((Object)1234, (Object)rowSet.property(propertyKind1));
        try {
            rowSet.property(propertyKind2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

