/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.impl.PropertyKindMap;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class PropertyKindMapTest {
    private static final PropertyKind<?> PROP1 = PropertyKind.create((String)"prop1", String.class);
    private static final PropertyKind<?> PROP2 = PropertyKind.create((String)"prop2", Integer.class);
    private static final PropertyKind<?> PROP3 = PropertyKind.create((String)"prop3", UUID.class);
    private static final UUID UUID = java.util.UUID.randomUUID();
    PropertyKindMap map = new PropertyKindMap();

    @Test
    public void testEmptyMap() {
        Assert.assertNull((Object)this.map.get(PROP1));
        Assert.assertNull((Object)this.map.get(PROP2));
        Assert.assertNull((Object)this.map.get(PROP3));
        Assert.assertEquals((long)0L, (long)this.map.count());
    }

    @Test
    public void testLookups() {
        this.map.put(PROP1, (Object)"foo");
        this.map.put(PROP2, (Object)42);
        this.map.put(PROP3, (Object)UUID);
        Assert.assertEquals((Object)"foo", (Object)this.map.get(PROP1));
        Assert.assertEquals((Object)42, (Object)this.map.get(PROP2));
        Assert.assertEquals((Object)UUID, (Object)this.map.get(PROP3));
        Assert.assertEquals((long)3L, (long)this.map.count());
    }

    @Test
    public void testDuplicateKey() {
        this.map.put(PROP1, (Object)"foo");
        this.map.put(PROP2, (Object)42);
        this.map.put(PROP3, (Object)UUID);
        this.map.put(PROP2, (Object)43);
        Assert.assertEquals((Object)"foo", (Object)this.map.get(PROP1));
        Assert.assertEquals((Object)43, (Object)this.map.get(PROP2));
        Assert.assertEquals((Object)UUID, (Object)this.map.get(PROP3));
        Assert.assertEquals((long)3L, (long)this.map.count());
    }
}

