/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.impl.cache.LruCache;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LruCacheTest {
    @Test
    public void testEvictOnInsertion() {
        int capacity = 1024;
        LruCache cache = new LruCache(capacity);
        for (int i = 0; i < capacity; ++i) {
            String key = "key-" + i;
            String value = "value-" + i;
            Assert.assertEquals((long)0L, (long)cache.cache((Object)key, (Object)value).size());
        }
        List evicted = cache.cache((Object)"key-1024", (Object)"value-1024");
        Assert.assertEquals((long)1L, (long)evicted.size());
        Assert.assertEquals((Object)"value-0", evicted.iterator().next());
        Assert.assertEquals((long)1024L, (long)cache.size());
    }

    @Test
    public void testEvict() {
        int capacity = 1024;
        LruCache cache = new LruCache(capacity);
        for (int i = 0; i < capacity; ++i) {
            String key = "key-" + i;
            String value = "value-" + i;
            Assert.assertEquals((long)0L, (long)cache.cache((Object)key, (Object)value).size());
        }
        String evicted = (String)cache.evict();
        Assert.assertEquals((Object)"value-0", (Object)evicted);
        Assert.assertEquals((long)1023L, (long)cache.size());
    }
}

