/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.benchmarks;

import io.vertx.sqlclient.benchmarks.RowAccumulatorType;
import io.vertx.sqlclient.benchmarks.Utils;
import io.vertx.sqlclient.impl.accumulator.RowAccumulator;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=20, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
@Fork(value=3, jvmArgs={"-Xms8g", "-Xmx8g", "-Xmn7g"})
public class RowAccumulatorWriteBenchmark {
    @Param(value={"ARRAY_LIST", "CHUNKED_FIXED_SIZE", "CHUNKED_GROWING_SIZE"})
    public RowAccumulatorType rowAccumulatorType;
    @Param(value={"5", "20", "65", "605", "1820", "5465", "16400"})
    int size;
    @Param(value={"false", "true"})
    boolean shuffle;
    @Param(value={"false", "true"})
    boolean gc;
    String[] arr;

    @Setup
    public void setup() throws IOException, InterruptedException {
        this.arr = Utils.generateStrings(this.size, this.shuffle, this.gc);
    }

    @Benchmark
    public RowAccumulator<String> accumulate() {
        RowAccumulator<String> rowAccumulator = this.rowAccumulatorType.newInstance();
        for (String s : this.arr) {
            rowAccumulator.accept((Object)s);
        }
        return rowAccumulator;
    }
}

