/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.benchmarks;

import io.vertx.sqlclient.impl.accumulator.ArrayListRowAccumulator;
import io.vertx.sqlclient.impl.accumulator.ChunkedRowAccumulator;
import io.vertx.sqlclient.impl.accumulator.RowAccumulator;
import java.util.function.IntUnaryOperator;

public enum RowAccumulatorType {
    ARRAY_LIST,
    CHUNKED_FIXED_SIZE,
    CHUNKED_GROWING_SIZE;


    RowAccumulator<String> newInstance() {
        switch (this) {
            case ARRAY_LIST: {
                return new ArrayListRowAccumulator();
            }
            case CHUNKED_FIXED_SIZE: {
                return new ChunkedRowAccumulator(IntUnaryOperator.identity());
            }
            case CHUNKED_GROWING_SIZE: {
                return new ChunkedRowAccumulator(size -> size + (size >> 1));
            }
        }
        throw new AssertionError();
    }
}

