/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.mqtt;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An MQTT client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.MqttClient.class)
public class MqttClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttClient that = (MqttClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttClient> __TYPE_ARG = new TypeArg<>(    obj -> new MqttClient((io.vertx.mqtt.MqttClient) obj),
    MqttClient::getDelegate
  );

  private final io.vertx.mqtt.MqttClient delegate;
  
  public MqttClient(io.vertx.mqtt.MqttClient delegate) {
    this.delegate = delegate;
  }

  public MqttClient(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttClient)delegate;
  }

  public io.vertx.mqtt.MqttClient getDelegate() {
    return delegate;
  }

  /**
   * Return an MQTT client instance
   * @param vertx Vert.x instance
   * @param options MQTT client options
   * @return MQTT client instance
   */
  public static io.vertx.reactivex.mqtt.MqttClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.mqtt.MqttClientOptions options) { 
    io.vertx.reactivex.mqtt.MqttClient ret = io.vertx.reactivex.mqtt.MqttClient.newInstance((io.vertx.mqtt.MqttClient)io.vertx.mqtt.MqttClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Return an MQTT client instance using the default options
   * @param vertx Vert.x instance
   * @return MQTT client instance
   */
  public static io.vertx.reactivex.mqtt.MqttClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.mqtt.MqttClient ret = io.vertx.reactivex.mqtt.MqttClient.newInstance((io.vertx.mqtt.MqttClient)io.vertx.mqtt.MqttClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param connectHandler handler called when the asynchronous connect call ends
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient connect(int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.mqtt.messages.MqttConnAckMessage>> connectHandler) { 
    delegate.connect(port, host, new io.vertx.lang.rx.DelegatingHandler<>(connectHandler, ar -> ar.map(event -> io.vertx.reactivex.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)event))));
    return this;
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient connect(int port, java.lang.String host) {
    return 
connect(port, host, ar -> { });
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @return current MQTT client instance
   */
  public io.reactivex.Single<io.vertx.reactivex.mqtt.messages.MqttConnAckMessage> rxConnect(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle($handler -> {
      connect(port, host, $handler);
    });
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @param connectHandler handler called when the asynchronous connect call ends
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient connect(int port, java.lang.String host, java.lang.String serverName, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.mqtt.messages.MqttConnAckMessage>> connectHandler) { 
    delegate.connect(port, host, serverName, new io.vertx.lang.rx.DelegatingHandler<>(connectHandler, ar -> ar.map(event -> io.vertx.reactivex.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)event))));
    return this;
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient connect(int port, java.lang.String host, java.lang.String serverName) {
    return 
connect(port, host, serverName, ar -> { });
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @return current MQTT client instance
   */
  public io.reactivex.Single<io.vertx.reactivex.mqtt.messages.MqttConnAckMessage> rxConnect(int port, java.lang.String host, java.lang.String serverName) { 
    return AsyncResultSingle.toSingle($handler -> {
      connect(port, host, serverName, $handler);
    });
  }

  /**
   * Disconnects from the MQTT server calling disconnectHandler after disconnection
   * @param disconnectHandler handler called when asynchronous disconnect call ends
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient disconnect(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> disconnectHandler) { 
    delegate.disconnect(disconnectHandler);
    return this;
  }

  /**
   * Disconnects from the MQTT server calling disconnectHandler after disconnection
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient disconnect() {
    return 
disconnect(ar -> { });
  }

  /**
   * Disconnects from the MQTT server calling disconnectHandler after disconnection
   * @return current MQTT client instance
   */
  public io.reactivex.Completable rxDisconnect() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      disconnect($handler);
    });
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param publishSentHandler handler called after PUBLISH packet sent with packetid (not when QoS 0)
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient publish(java.lang.String topic, io.vertx.reactivex.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Integer>> publishSentHandler) { 
    delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient publish(java.lang.String topic, io.vertx.reactivex.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) {
    return 
publish(topic, payload, qosLevel, isDup, isRetain, ar -> { });
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return current MQTT client instance
   */
  public io.reactivex.Single<java.lang.Integer> rxPublish(java.lang.String topic, io.vertx.reactivex.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    return AsyncResultSingle.toSingle($handler -> {
      publish(topic, payload, qosLevel, isDup, isRetain, $handler);
    });
  }

  /**
   * Sets a handler which will be called each time the publishing of a message has been completed.
   * <p>
   * For a message that has been published using
   * <ul>
   * <li>QoS 0 this means that the client has successfully sent the corresponding PUBLISH packet,</li>
   * <li>QoS 1 this means that a corresponding PUBACK has been received from the server,</li>
   * <li>QoS 2 this means that a corresponding PUBCOMP has been received from the server.</li>
   * </ul>
   * @param publishCompletionHandler handler called with the packetId
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient publishCompletionHandler(io.vertx.core.Handler<java.lang.Integer> publishCompletionHandler) { 
    delegate.publishCompletionHandler(publishCompletionHandler);
    return this;
  }

  /**
   * Sets a handler which will be called when the client does not receive a PUBACK or
   * PUBREC/PUBCOMP for a message published using QoS 1 or 2 respectively.
   * <p>
   * The time to wait for an acknowledgement message can be configured using
   * {@link io.vertx.mqtt.MqttClientOptions}.
   * If the client receives a PUBACK/PUBREC/PUBCOMP for a message after its completion
   * has expired, the handler registered using {@link io.vertx.reactivex.mqtt.MqttClient#publishCompletionUnknownPacketIdHandler}
   * will be invoked.
   * <p>
   * Note that this behavior is outside the scope of the MQTT 3.1.1 specification. The client's default
   * behavior is therefore to wait forever for the server's corresponding acknowledgement.
   * @param publishCompletionExpirationHandler the handler to call with the ID of the expired packet
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient publishCompletionExpirationHandler(io.vertx.core.Handler<java.lang.Integer> publishCompletionExpirationHandler) { 
    delegate.publishCompletionExpirationHandler(publishCompletionExpirationHandler);
    return this;
  }

  /**
   * Sets a handler which will be called when the client receives a PUBACK/PUBREC/PUBCOMP with an unknown
   * packet ID.
   * @param publishCompletionPhantomHandler the handler to call with the unknown packet ID
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient publishCompletionUnknownPacketIdHandler(io.vertx.core.Handler<java.lang.Integer> publishCompletionPhantomHandler) { 
    delegate.publishCompletionUnknownPacketIdHandler(publishCompletionPhantomHandler);
    return this;
  }

  /**
   * Sets handler which will be called each time server publish something to client
   * @param publishHandler handler to call
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient publishHandler(io.vertx.core.Handler<io.vertx.reactivex.mqtt.messages.MqttPublishMessage> publishHandler) { 
    delegate.publishHandler(new io.vertx.lang.rx.DelegatingHandler<>(publishHandler, event -> io.vertx.reactivex.mqtt.messages.MqttPublishMessage.newInstance((io.vertx.mqtt.messages.MqttPublishMessage)event)));
    return this;
  }

  /**
   * Sets handler which will be called after SUBACK packet receiving
   * @param subscribeCompletionHandler handler to call. List inside is a granted QoS array
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient subscribeCompletionHandler(io.vertx.core.Handler<io.vertx.reactivex.mqtt.messages.MqttSubAckMessage> subscribeCompletionHandler) { 
    delegate.subscribeCompletionHandler(new io.vertx.lang.rx.DelegatingHandler<>(subscribeCompletionHandler, event -> io.vertx.reactivex.mqtt.messages.MqttSubAckMessage.newInstance((io.vertx.mqtt.messages.MqttSubAckMessage)event)));
    return this;
  }

  /**
   * Subscribes to the topic with a specified QoS level
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @param subscribeSentHandler handler called after SUBSCRIBE packet sent with packetid
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient subscribe(java.lang.String topic, int qos, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Integer>> subscribeSentHandler) { 
    delegate.subscribe(topic, qos, subscribeSentHandler);
    return this;
  }

  /**
   * Subscribes to the topic with a specified QoS level
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient subscribe(java.lang.String topic, int qos) {
    return 
subscribe(topic, qos, ar -> { });
  }

  /**
   * Subscribes to the topic with a specified QoS level
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @return current MQTT client instance
   */
  public io.reactivex.Single<java.lang.Integer> rxSubscribe(java.lang.String topic, int qos) { 
    return AsyncResultSingle.toSingle($handler -> {
      subscribe(topic, qos, $handler);
    });
  }

  /**
   * Subscribes to the topic and adds a handler which will be called after the request is sent
   * @param topics topics you subscribe on
   * @param subscribeSentHandler handler called after SUBSCRIBE packet sent with packetid
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient subscribe(java.util.Map<java.lang.String,java.lang.Integer> topics, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Integer>> subscribeSentHandler) { 
    delegate.subscribe(topics, subscribeSentHandler);
    return this;
  }

  /**
   * Subscribes to the topic and adds a handler which will be called after the request is sent
   * @param topics topics you subscribe on
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient subscribe(java.util.Map<java.lang.String,java.lang.Integer> topics) {
    return 
subscribe(topics, ar -> { });
  }

  /**
   * Subscribes to the topic and adds a handler which will be called after the request is sent
   * @param topics topics you subscribe on
   * @return current MQTT client instance
   */
  public io.reactivex.Single<java.lang.Integer> rxSubscribe(java.util.Map<java.lang.String,java.lang.Integer> topics) { 
    return AsyncResultSingle.toSingle($handler -> {
      subscribe(topics, $handler);
    });
  }

  /**
   * Sets handler which will be called after UNSUBACK packet receiving
   * @param unsubscribeCompletionHandler handler to call with the packetid
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient unsubscribeCompletionHandler(io.vertx.core.Handler<java.lang.Integer> unsubscribeCompletionHandler) { 
    delegate.unsubscribeCompletionHandler(unsubscribeCompletionHandler);
    return this;
  }

  /**
   * Unsubscribe from receiving messages on given topics
   * @param topics list of topics you want to unsubscribe from
   * @param unsubscribeSentHandler handler called after UNSUBSCRIBE packet sent
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient unsubscribe(java.util.List<java.lang.String> topics, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Integer>> unsubscribeSentHandler) { 
    delegate.unsubscribe(topics, unsubscribeSentHandler);
    return this;
  }

  /**
   * Unsubscribe from receiving messages on given topics
   * @param topics list of topics you want to unsubscribe from
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient unsubscribe(java.util.List<java.lang.String> topics) {
    return 
unsubscribe(topics, ar -> { });
  }

  /**
   * Unsubscribe from receiving messages on given topics
   * @param topics list of topics you want to unsubscribe from
   * @return current MQTT client instance
   */
  public io.reactivex.Single<java.lang.Integer> rxUnsubscribe(java.util.List<java.lang.String> topics) { 
    return AsyncResultSingle.toSingle($handler -> {
      unsubscribe(topics, $handler);
    });
  }

  /**
   * Unsubscribe from receiving messages on given topic
   * @param topic list of topics you want to unsubscribe from
   * @param unsubscribeSentHandler handler called after UNSUBSCRIBE packet sent
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient unsubscribe(java.lang.String topic, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Integer>> unsubscribeSentHandler) { 
    delegate.unsubscribe(topic, unsubscribeSentHandler);
    return this;
  }

  /**
   * Unsubscribe from receiving messages on given topic
   * @param topic list of topics you want to unsubscribe from
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient unsubscribe(java.lang.String topic) {
    return 
unsubscribe(topic, ar -> { });
  }

  /**
   * Unsubscribe from receiving messages on given topic
   * @param topic list of topics you want to unsubscribe from
   * @return current MQTT client instance
   */
  public io.reactivex.Single<java.lang.Integer> rxUnsubscribe(java.lang.String topic) { 
    return AsyncResultSingle.toSingle($handler -> {
      unsubscribe(topic, $handler);
    });
  }

  /**
   * Sets handler which will be called after PINGRESP packet receiving
   * @param pingResponseHandler handler to call
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient pingResponseHandler(io.vertx.core.Handler<java.lang.Void> pingResponseHandler) { 
    delegate.pingResponseHandler(pingResponseHandler);
    return this;
  }

  /**
   * Set an exception handler for the client, that will be called when an error happens
   * in internal netty structures.
   *
   * <code>io.netty.handler.codec.DecoderException</code> can be one of the cause
   * @param handler the exception handler
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set a handler that will be called when the connection with server is closed
   * @param closeHandler handler to call
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient closeHandler(io.vertx.core.Handler<java.lang.Void> closeHandler) { 
    delegate.closeHandler(closeHandler);
    return this;
  }

  /**
   * This method is needed by the client in order to avoid server closes the
   * connection due to the keep alive timeout if client has no messages to send
   * @return current MQTT client instance
   */
  public io.vertx.reactivex.mqtt.MqttClient ping() { 
    delegate.ping();
    return this;
  }

  /**
   * @return the client identifier
   */
  public java.lang.String clientId() { 
    java.lang.String ret = delegate.clientId();
    return ret;
  }

  /**
   * @return if the connection between client and remote server is established/open
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  public static MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
    return arg != null ? new MqttClient(arg) : null;
  }

}
