/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql.schema;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Extends  so that properties can be read from a .
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.schema.VertxPropertyDataFetcher original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.schema.VertxPropertyDataFetcher.class)
public class VertxPropertyDataFetcher {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VertxPropertyDataFetcher that = (VertxPropertyDataFetcher) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<VertxPropertyDataFetcher> __TYPE_ARG = new TypeArg<>(    obj -> new VertxPropertyDataFetcher((io.vertx.ext.web.handler.graphql.schema.VertxPropertyDataFetcher) obj),
    VertxPropertyDataFetcher::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.schema.VertxPropertyDataFetcher delegate;
  
  public VertxPropertyDataFetcher(io.vertx.ext.web.handler.graphql.schema.VertxPropertyDataFetcher delegate) {
    this.delegate = delegate;
  }

  public VertxPropertyDataFetcher(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.schema.VertxPropertyDataFetcher)delegate;
  }

  public io.vertx.ext.web.handler.graphql.schema.VertxPropertyDataFetcher getDelegate() {
    return delegate;
  }


  @Deprecated()
  public static graphql.schema.PropertyDataFetcher<java.lang.Object> create(java.lang.String propertyName) { 
    graphql.schema.PropertyDataFetcher<java.lang.Object> ret = io.vertx.ext.web.handler.graphql.schema.VertxPropertyDataFetcher.create(propertyName);
    return ret;
  }

  public static VertxPropertyDataFetcher newInstance(io.vertx.ext.web.handler.graphql.schema.VertxPropertyDataFetcher arg) {
    return arg != null ? new VertxPropertyDataFetcher(arg) : null;
  }

}
