/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.common.template;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A template template uses a specific template and the data in a routing context to render a resource into a buffer.
 * <p>
 * Concrete implementations exist for several well-known template engines.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.common.template.TemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.common.template.TemplateEngine.class)
public class TemplateEngine {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TemplateEngine that = (TemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TemplateEngine> __TYPE_ARG = new TypeArg<>(    obj -> new TemplateEngine((io.vertx.ext.web.common.template.TemplateEngine) obj),
    TemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.common.template.TemplateEngine delegate;
  
  public TemplateEngine(io.vertx.ext.web.common.template.TemplateEngine delegate) {
    this.delegate = delegate;
  }

  public TemplateEngine(Object delegate) {
    this.delegate = (io.vertx.ext.web.common.template.TemplateEngine)delegate;
  }

  public io.vertx.ext.web.common.template.TemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @param handler the handler that will be called with a result containing the buffer or a failure.
   */
  public void render(io.vertx.core.json.JsonObject context, java.lang.String templateFileName, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) { 
    delegate.render(context, templateFileName, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   */
  public void render(io.vertx.core.json.JsonObject context, java.lang.String templateFileName) {
    render(context, templateFileName, ar -> { });
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.core.buffer.Buffer> rxRender(io.vertx.core.json.JsonObject context, java.lang.String templateFileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      render(context, templateFileName, $handler);
    });
  }

  /**
   * Clears any internal caches used by this engine. For most engines this means clearing the
   * vert.x cache, implementations that do not use vert.x as a cache should clear their own cache.
   */
  public void clearCache() { 
    delegate.clearCache();
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @param handler the handler that will be called with a result containing the buffer or a failure.
   */
  public void render(java.util.Map<java.lang.String,java.lang.Object> context, java.lang.String templateFileName, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) { 
    delegate.render(context, templateFileName, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   */
  public void render(java.util.Map<java.lang.String,java.lang.Object> context, java.lang.String templateFileName) {
    render(context, templateFileName, ar -> { });
  }

  /**
   * Render the template. Template engines that support partials/fragments should extract the template base path from
   * the template filename up to the last file separator.
   *
   * Some engines support localization, for these engines, there is a predefined key "lang" to specify the language to
   * be used in the localization, the format should follow the standard locale formats e.g.: "en-gb", "pt-br", "en".
   * @param context the routing context
   * @param templateFileName the template file name to use
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.core.buffer.Buffer> rxRender(java.util.Map<java.lang.String,java.lang.Object> context, java.lang.String templateFileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      render(context, templateFileName, $handler);
    });
  }

  /**
   * Returns the underlying engine, so further configurations or customizations may be applied.
   * @return the engine instance.
   */
  public <T> T unwrap() { 
    T ret = (T) delegate.unwrap();
    return ret;
  }

  public static TemplateEngine newInstance(io.vertx.ext.web.common.template.TemplateEngine arg) {
    return arg != null ? new TemplateEngine(arg) : null;
  }

}
