/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An HTTP response.
 * <p>
 * The usual HTTP response attributes are available:
 * <ul>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpResponse#statusCode} the HTTP status code</li>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpResponse#statusMessage} the HTTP status message</li>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpResponse#headers} the HTTP headers</li>
 *   <li>{@link io.vertx.reactivex.ext.web.client.HttpResponse#version} the HTTP version</li>
 * </ul>
 * <p>
 * The body of the response is returned by {@link io.vertx.reactivex.ext.web.client.HttpResponse#body} decoded as the format specified by the {@link io.vertx.reactivex.ext.web.codec.BodyCodec} that
 * built the response.
 * <p>
 * Keep in mind that using this <code>HttpResponse</code> impose to fully buffer the response body and should be used for payload
 * that can fit in memory.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.HttpResponse original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.client.HttpResponse.class)
public class HttpResponse<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpResponse that = (HttpResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpResponse> __TYPE_ARG = new TypeArg<>(    obj -> new HttpResponse((io.vertx.ext.web.client.HttpResponse) obj),
    HttpResponse::getDelegate
  );

  private final io.vertx.ext.web.client.HttpResponse<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public HttpResponse(io.vertx.ext.web.client.HttpResponse delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public HttpResponse(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.ext.web.client.HttpResponse)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.ext.web.client.HttpResponse getDelegate() {
    return delegate;
  }


  /**
   * @return the version of the response
   */
  public io.vertx.core.http.HttpVersion version() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.http.HttpVersion ret = delegate.version();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the status code of the response
   */
  public int statusCode() { 
    if (cached_1 != null) {
      return cached_1;
    }
    int ret = delegate.statusCode();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the status message of the response
   */
  public java.lang.String statusMessage() { 
    if (cached_2 != null) {
      return cached_2;
    }
    java.lang.String ret = delegate.statusMessage();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.reactivex.core.MultiMap headers() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    cached_3 = ret;
    return ret;
  }

  /**
   * Return the first header value with the specified name
   * @param headerName the header name
   * @return the header value
   */
  public java.lang.String getHeader(java.lang.String headerName) { 
    java.lang.String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * @return the trailers
   */
  public io.vertx.reactivex.core.MultiMap trailers() { 
    if (cached_4 != null) {
      return cached_4;
    }
    io.vertx.reactivex.core.MultiMap ret = io.vertx.reactivex.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.trailers());
    cached_4 = ret;
    return ret;
  }

  /**
   * Return the first trailer value with the specified name
   * @param trailerName the trailer name
   * @return the trailer value
   */
  public java.lang.String getTrailer(java.lang.String trailerName) { 
    java.lang.String ret = delegate.getTrailer(trailerName);
    return ret;
  }

  /**
   * @return the Set-Cookie headers (including trailers)
   */
  public java.util.List<java.lang.String> cookies() { 
    if (cached_5 != null) {
      return cached_5;
    }
    java.util.List<java.lang.String> ret = delegate.cookies();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return the response body in the format it was decoded.
   */
  public T body() { 
    if (cached_6 != null) {
      return cached_6;
    }
    T ret = (T)__typeArg_0.wrap(delegate.body());
    cached_6 = ret;
    return ret;
  }

  /**
   * @return the response body decoded as a , or <code>null</code> if a codec other than  was used
   */
  public io.vertx.reactivex.core.buffer.Buffer bodyAsBuffer() { 
    if (cached_7 != null) {
      return cached_7;
    }
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.bodyAsBuffer());
    cached_7 = ret;
    return ret;
  }

  /**
   * @return the list of all followed redirects, including the final location.
   */
  public java.util.List<java.lang.String> followedRedirects() { 
    if (cached_8 != null) {
      return cached_8;
    }
    java.util.List<java.lang.String> ret = delegate.followedRedirects();
    cached_8 = ret;
    return ret;
  }

  /**
   * @return the response body decoded as a <code>String</code>, or <code>null</code> if a codec other than  was used
   */
  public java.lang.String bodyAsString() { 
    if (cached_9 != null) {
      return cached_9;
    }
    java.lang.String ret = delegate.bodyAsString();
    cached_9 = ret;
    return ret;
  }

  /**
   * @param encoding 
   * @return the response body decoded as a <code>String</code> given a specific <code>encoding</code>, or <code>null</code> if a codec other than  was used
   */
  public java.lang.String bodyAsString(java.lang.String encoding) { 
    java.lang.String ret = delegate.bodyAsString(encoding);
    return ret;
  }

  /**
   * @return the response body decoded as , or <code>null</code> if a codec other than  was used
   */
  public io.vertx.core.json.JsonObject bodyAsJsonObject() { 
    if (cached_10 != null) {
      return cached_10;
    }
    io.vertx.core.json.JsonObject ret = delegate.bodyAsJsonObject();
    cached_10 = ret;
    return ret;
  }

  /**
   * @return the response body decoded as a , or <code>null</code> if a codec other than  was used
   */
  public io.vertx.core.json.JsonArray bodyAsJsonArray() { 
    if (cached_11 != null) {
      return cached_11;
    }
    io.vertx.core.json.JsonArray ret = delegate.bodyAsJsonArray();
    cached_11 = ret;
    return ret;
  }

  /**
   * @param type 
   * @return the response body decoded as the specified <code>type</code> with the Jackson mapper, or <code>null</code> if a codec other than  was used
   */
  public <R> R bodyAsJson(java.lang.Class<R> type) { 
    R ret = (R)TypeArg.of(type).wrap(delegate.bodyAsJson(io.vertx.lang.reactivex.Helper.unwrap(type)));
    return ret;
  }

  private io.vertx.core.http.HttpVersion cached_0;
  private java.lang.Integer cached_1;
  private java.lang.String cached_2;
  private io.vertx.reactivex.core.MultiMap cached_3;
  private io.vertx.reactivex.core.MultiMap cached_4;
  private java.util.List<java.lang.String> cached_5;
  private T cached_6;
  private io.vertx.reactivex.core.buffer.Buffer cached_7;
  private java.util.List<java.lang.String> cached_8;
  private java.lang.String cached_9;
  private io.vertx.core.json.JsonObject cached_10;
  private io.vertx.core.json.JsonArray cached_11;
  public static <T> HttpResponse<T> newInstance(io.vertx.ext.web.client.HttpResponse arg) {
    return arg != null ? new HttpResponse<T>(arg) : null;
  }

  public static <T> HttpResponse<T> newInstance(io.vertx.ext.web.client.HttpResponse arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new HttpResponse<T>(arg, __typeArg_T) : null;
  }

}
