/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Request parameter holder
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.RequestParameter original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.RequestParameter.class)
public class RequestParameter {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestParameter that = (RequestParameter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RequestParameter> __TYPE_ARG = new TypeArg<>(    obj -> new RequestParameter((io.vertx.ext.web.api.RequestParameter) obj),
    RequestParameter::getDelegate
  );

  private final io.vertx.ext.web.api.RequestParameter delegate;
  
  public RequestParameter(io.vertx.ext.web.api.RequestParameter delegate) {
    this.delegate = delegate;
  }

  public RequestParameter(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.RequestParameter)delegate;
  }

  public io.vertx.ext.web.api.RequestParameter getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.web.api.RequestParameter> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.web.api.RequestParameter>(o1 -> io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)o1), o1 -> o1.getDelegate());

  /**
   * Set parameter name
   * @param name 
   */
  @Deprecated()
  public void setName(java.lang.String name) { 
    delegate.setName(name);
  }

  /**
   * Set value
   * @param value 
   */
  @Deprecated()
  public void setValue(java.lang.Object value) { 
    delegate.setValue(value);
  }

  /**
   * Get parameter name
   * @return 
   */
  @Deprecated()
  public java.lang.String getName() { 
    java.lang.String ret = delegate.getName();
    return ret;
  }

  /**
   * If value is a map of fields, it returns keys of map, otherwise it returns null
   * @return 
   */
  @Deprecated()
  public java.util.List<java.lang.String> getObjectKeys() { 
    java.util.List<java.lang.String> ret = delegate.getObjectKeys();
    return ret;
  }

  /**
   * If value is a map of fields, it returns value of field with key provided, otherwise it returns null
   * @param key 
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.RequestParameter getObjectValue(java.lang.String key) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.getObjectValue(key));
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is a map of fields
   * @return 
   */
  @Deprecated()
  public boolean isObject() { 
    boolean ret = delegate.isObject();
    return ret;
  }

  /**
   * Returns null if value is not a list, otherwise it returns value
   * @return 
   */
  @Deprecated()
  public java.util.List<io.vertx.reactivex.ext.web.api.RequestParameter> getArray() { 
    java.util.List<io.vertx.reactivex.ext.web.api.RequestParameter> ret = delegate.getArray().stream().map(elt -> io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is an array
   * @return 
   */
  @Deprecated()
  public boolean isArray() { 
    boolean ret = delegate.isArray();
    return ret;
  }

  /**
   * Returns null if value is not a String, otherwise it returns value
   * @return 
   */
  @Deprecated()
  public java.lang.String getString() { 
    java.lang.String ret = delegate.getString();
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is a String instance
   * @return 
   */
  @Deprecated()
  public boolean isString() { 
    boolean ret = delegate.isString();
    return ret;
  }

  /**
   * Returns null if value is not an Integer, otherwise it returns value
   * @return 
   */
  @Deprecated()
  public java.lang.Integer getInteger() { 
    java.lang.Integer ret = delegate.getInteger();
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is an Integer instance
   * @return 
   */
  @Deprecated()
  public boolean isInteger() { 
    boolean ret = delegate.isInteger();
    return ret;
  }

  /**
   * Returns null if value is not a Long, otherwise it returns value
   * @return 
   */
  @Deprecated()
  public java.lang.Long getLong() { 
    java.lang.Long ret = delegate.getLong();
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is a Long instance
   * @return 
   */
  @Deprecated()
  public boolean isLong() { 
    boolean ret = delegate.isLong();
    return ret;
  }

  /**
   * Returns null if value is not a Float, otherwise it returns value
   * @return 
   */
  @Deprecated()
  public java.lang.Float getFloat() { 
    java.lang.Float ret = delegate.getFloat();
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is a Float instance
   * @return 
   */
  @Deprecated()
  public boolean isFloat() { 
    boolean ret = delegate.isFloat();
    return ret;
  }

  /**
   * Returns null if value is not a Double, otherwise it returns value
   * @return 
   */
  @Deprecated()
  public java.lang.Double getDouble() { 
    java.lang.Double ret = delegate.getDouble();
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is a Double instance
   * @return 
   */
  @Deprecated()
  public boolean isDouble() { 
    boolean ret = delegate.isDouble();
    return ret;
  }

  /**
   * Returns null if value is not a Boolean, otherwise it returns value
   * @return 
   */
  @Deprecated()
  public java.lang.Boolean getBoolean() { 
    java.lang.Boolean ret = delegate.getBoolean();
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is a Boolean instance
   * @return 
   */
  @Deprecated()
  public boolean isBoolean() { 
    boolean ret = delegate.isBoolean();
    return ret;
  }

  /**
   * Returns null if value is not a JsonObject, otherwise it returns value
   * @return 
   */
  @Deprecated()
  public io.vertx.core.json.JsonObject getJsonObject() { 
    io.vertx.core.json.JsonObject ret = delegate.getJsonObject();
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is a JsonObject instance
   * @return 
   */
  @Deprecated()
  public boolean isJsonObject() { 
    boolean ret = delegate.isJsonObject();
    return ret;
  }

  /**
   * Returns null if value is not a JsonArray, otherwise it returns value
   * @return 
   */
  @Deprecated()
  public io.vertx.core.json.JsonArray getJsonArray() { 
    io.vertx.core.json.JsonArray ret = delegate.getJsonArray();
    return ret;
  }

  /**
   * Returns true if value of RequestParameter is a JsonArray instance
   * @return 
   */
  @Deprecated()
  public boolean isJsonArray() { 
    boolean ret = delegate.isJsonArray();
    return ret;
  }

  /**
   * Returns true if value is null
   * @return 
   */
  @Deprecated()
  public boolean isNull() { 
    boolean ret = delegate.isNull();
    return ret;
  }

  /**
   * Alias of {@link io.vertx.reactivex.ext.web.api.RequestParameter#isNull}
   * @return 
   */
  @Deprecated()
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * Converts deeply this RequestParameter in a Json representation
   * @return 
   */
  @Deprecated()
  public java.lang.Object toJson() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.Object ret = (Object) delegate.toJson();
    cached_0 = ret;
    return ret;
  }

  /**
   * Merge this request parameter with another one. Note: the parameter passed by argument has the priority
   * @param otherParameter 
   * @return 
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.RequestParameter merge(io.vertx.reactivex.ext.web.api.RequestParameter otherParameter) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.merge(otherParameter.getDelegate()));
    return ret;
  }

  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.RequestParameter create(java.lang.String name, java.lang.Object value) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)io.vertx.ext.web.api.RequestParameter.create(name, value));
    return ret;
  }

  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.RequestParameter create(java.lang.Object value) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)io.vertx.ext.web.api.RequestParameter.create(value));
    return ret;
  }

  private java.lang.Object cached_0;
  public static RequestParameter newInstance(io.vertx.ext.web.api.RequestParameter arg) {
    return arg != null ? new RequestParameter(arg) : null;
  }

}
