/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.unit;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A test case object can be used to create a single test.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.TestCase original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.unit.TestCase.class)
public class TestCase {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TestCase that = (TestCase) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TestCase> __TYPE_ARG = new TypeArg<>(    obj -> new TestCase((io.vertx.ext.unit.TestCase) obj),
    TestCase::getDelegate
  );

  private final io.vertx.ext.unit.TestCase delegate;
  
  public TestCase(io.vertx.ext.unit.TestCase delegate) {
    this.delegate = delegate;
  }

  public TestCase(Object delegate) {
    this.delegate = (io.vertx.ext.unit.TestCase)delegate;
  }

  public io.vertx.ext.unit.TestCase getDelegate() {
    return delegate;
  }

  /**
   * Create a test case.
   * @param name the test case name
   * @param testCase the test case
   * @return the created test case
   */
  public static io.vertx.reactivex.ext.unit.TestCase create(java.lang.String name, io.vertx.core.Handler<io.vertx.reactivex.ext.unit.TestContext> testCase) { 
    io.vertx.reactivex.ext.unit.TestCase ret = io.vertx.reactivex.ext.unit.TestCase.newInstance((io.vertx.ext.unit.TestCase)io.vertx.ext.unit.TestCase.create(name, new io.vertx.lang.rx.DelegatingHandler<>(testCase, event -> io.vertx.reactivex.ext.unit.TestContext.newInstance((io.vertx.ext.unit.TestContext)event))));
    return ret;
  }

  public static TestCase newInstance(io.vertx.ext.unit.TestCase arg) {
    return arg != null ? new TestCase(arg) : null;
  }

}
