/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.command;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A build for Vert.x Shell command.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.command.CommandBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.command.CommandBuilder.class)
public class CommandBuilder {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CommandBuilder that = (CommandBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CommandBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new CommandBuilder((io.vertx.ext.shell.command.CommandBuilder) obj),
    CommandBuilder::getDelegate
  );

  private final io.vertx.ext.shell.command.CommandBuilder delegate;
  
  public CommandBuilder(io.vertx.ext.shell.command.CommandBuilder delegate) {
    this.delegate = delegate;
  }

  public CommandBuilder(Object delegate) {
    this.delegate = (io.vertx.ext.shell.command.CommandBuilder)delegate;
  }

  public io.vertx.ext.shell.command.CommandBuilder getDelegate() {
    return delegate;
  }

  /**
   * Create a new commmand builder, the command is responsible for managing the options and arguments via the
   * {@link io.vertx.reactivex.ext.shell.command.CommandProcess #args() arguments}.
   * @param name the command name
   * @return the command
   */
  public static io.vertx.reactivex.ext.shell.command.CommandBuilder command(java.lang.String name) { 
    io.vertx.reactivex.ext.shell.command.CommandBuilder ret = io.vertx.reactivex.ext.shell.command.CommandBuilder.newInstance((io.vertx.ext.shell.command.CommandBuilder)io.vertx.ext.shell.command.CommandBuilder.command(name));
    return ret;
  }

  /**
   * Create a new commmand with its {@link io.vertx.reactivex.core.cli.CLI} descriptor. This command can then retrieve the parsed
   * {@link io.vertx.reactivex.ext.shell.command.CommandProcess#commandLine} when it executes to know get the command arguments and options.
   * @param cli the cli to use
   * @return the command
   */
  public static io.vertx.reactivex.ext.shell.command.CommandBuilder command(io.vertx.reactivex.core.cli.CLI cli) { 
    io.vertx.reactivex.ext.shell.command.CommandBuilder ret = io.vertx.reactivex.ext.shell.command.CommandBuilder.newInstance((io.vertx.ext.shell.command.CommandBuilder)io.vertx.ext.shell.command.CommandBuilder.command(cli.getDelegate()));
    return ret;
  }

  /**
   * Set the command process handler, the process handler is called when the command is executed.
   * @param handler the process handler
   * @return this command object
   */
  public io.vertx.reactivex.ext.shell.command.CommandBuilder processHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.shell.command.CommandProcess> handler) { 
    delegate.processHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.reactivex.ext.shell.command.CommandProcess.newInstance((io.vertx.ext.shell.command.CommandProcess)event)));
    return this;
  }

  /**
   * Set the command completion handler, the completion handler when the user asks for contextual command line
   * completion, usually hitting the <i>tab</i> key.
   * @param handler the completion handler
   * @return this command object
   */
  public io.vertx.reactivex.ext.shell.command.CommandBuilder completionHandler(io.vertx.core.Handler<io.vertx.reactivex.ext.shell.cli.Completion> handler) { 
    delegate.completionHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.reactivex.ext.shell.cli.Completion.newInstance((io.vertx.ext.shell.cli.Completion)event)));
    return this;
  }

  /**
   * Build the command
   * @param vertx the vertx instance
   * @return the built command
   */
  public io.vertx.reactivex.ext.shell.command.Command build(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.shell.command.Command ret = io.vertx.reactivex.ext.shell.command.Command.newInstance((io.vertx.ext.shell.command.Command)delegate.build(vertx.getDelegate()));
    return ret;
  }

  public static CommandBuilder newInstance(io.vertx.ext.shell.command.CommandBuilder arg) {
    return arg != null ? new CommandBuilder(arg) : null;
  }

}
