/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mongo;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.mongo.MongoGridFsClient.class)
public class MongoGridFsClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoGridFsClient that = (MongoGridFsClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoGridFsClient> __TYPE_ARG = new TypeArg<>(    obj -> new MongoGridFsClient((io.vertx.ext.mongo.MongoGridFsClient) obj),
    MongoGridFsClient::getDelegate
  );

  private final io.vertx.ext.mongo.MongoGridFsClient delegate;
  
  public MongoGridFsClient(io.vertx.ext.mongo.MongoGridFsClient delegate) {
    this.delegate = delegate;
  }

  public MongoGridFsClient(Object delegate) {
    this.delegate = (io.vertx.ext.mongo.MongoGridFsClient)delegate;
  }

  public io.vertx.ext.mongo.MongoGridFsClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.buffer.Buffer> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.core.buffer.Buffer>(o1 -> io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Deletes a file by it's ID
   * @param id the identifier of the file
   * @param resultHandler will be called when the file is deleted
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient delete(java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.delete(id, resultHandler);
    return this;
  }

  /**
   * Deletes a file by it's ID
   * @param id the identifier of the file
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient delete(java.lang.String id) {
    return 
delete(id, ar -> { });
  }

  /**
   * Deletes a file by it's ID
   * @param id the identifier of the file
   * @return 
   */
  public io.reactivex.Completable rxDelete(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      delete(id, $handler);
    });
  }

  /**
   * Read file by name to ReadStream
   * @param fileName 
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> readByFileName(java.lang.String fileName) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.readByFileName(fileName), TYPE_ARG_0);
    return ret;
  }

  /**
   * Read file by name to ReadStream with options
   * @param fileName 
   * @param options 
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> readByFileNameWithOptions(java.lang.String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.readByFileNameWithOptions(fileName, options), TYPE_ARG_1);
    return ret;
  }

  /**
   * Read file by id to ReadStream
   * @param id 
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> readById(java.lang.String id) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.readById(id), TYPE_ARG_2);
    return ret;
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadByFileName(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.downloadByFileName(stream.getDelegate(), fileName, resultHandler);
    return this;
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadByFileName(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName) {
    return 
downloadByFileName(stream, fileName, ar -> { });
  }

  public io.reactivex.Single<java.lang.Long> rxDownloadByFileName(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      downloadByFileName(stream, fileName, $handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadByFileNameWithOptions(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.downloadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler);
    return this;
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadByFileNameWithOptions(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) {
    return 
downloadByFileNameWithOptions(stream, fileName, options, ar -> { });
  }

  public io.reactivex.Single<java.lang.Long> rxDownloadByFileNameWithOptions(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      downloadByFileNameWithOptions(stream, fileName, options, $handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadById(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String id, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.downloadById(stream.getDelegate(), id, resultHandler);
    return this;
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadById(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String id) {
    return 
downloadById(stream, id, ar -> { });
  }

  public io.reactivex.Single<java.lang.Long> rxDownloadById(io.vertx.reactivex.core.streams.WriteStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      downloadById(stream, id, $handler);
    });
  }

  /**
   * Downloads a file.
   * @param fileName the name of the file to download
   * @param resultHandler called when the file is downloaded and returns the length in bytes
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadFile(java.lang.String fileName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.downloadFile(fileName, resultHandler);
    return this;
  }

  /**
   * Downloads a file.
   * @param fileName the name of the file to download
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadFile(java.lang.String fileName) {
    return 
downloadFile(fileName, ar -> { });
  }

  /**
   * Downloads a file.
   * @param fileName the name of the file to download
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxDownloadFile(java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      downloadFile(fileName, $handler);
    });
  }

  /**
   * Downloads a file and gives it a new name.
   * @param fileName the name of the file to download
   * @param newFileName the name the file should be saved as
   * @param resultHandler called when the file is downloaded and returns the length in bytes
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadFileAs(java.lang.String fileName, java.lang.String newFileName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.downloadFileAs(fileName, newFileName, resultHandler);
    return this;
  }

  /**
   * Downloads a file and gives it a new name.
   * @param fileName the name of the file to download
   * @param newFileName the name the file should be saved as
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadFileAs(java.lang.String fileName, java.lang.String newFileName) {
    return 
downloadFileAs(fileName, newFileName, ar -> { });
  }

  /**
   * Downloads a file and gives it a new name.
   * @param fileName the name of the file to download
   * @param newFileName the name the file should be saved as
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxDownloadFileAs(java.lang.String fileName, java.lang.String newFileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      downloadFileAs(fileName, newFileName, $handler);
    });
  }

  /**
   * Downloads a file using the ID generated by GridFs.
   * @param id the GridFs Object ID of the file to download
   * @param fileName 
   * @param resultHandler called when the file is downloaded and returns the length in bytes
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadFileByID(java.lang.String id, java.lang.String fileName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Long>> resultHandler) { 
    delegate.downloadFileByID(id, fileName, resultHandler);
    return this;
  }

  /**
   * Downloads a file using the ID generated by GridFs.
   * @param id the GridFs Object ID of the file to download
   * @param fileName 
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient downloadFileByID(java.lang.String id, java.lang.String fileName) {
    return 
downloadFileByID(id, fileName, ar -> { });
  }

  /**
   * Downloads a file using the ID generated by GridFs.
   * @param id the GridFs Object ID of the file to download
   * @param fileName 
   * @return 
   */
  public io.reactivex.Single<java.lang.Long> rxDownloadFileByID(java.lang.String id, java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      downloadFileByID(id, fileName, $handler);
    });
  }

  /**
   * Drops the entire file bucket with all of its contents
   * @param resultHandler called when the bucket is dropped
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient drop(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.drop(resultHandler);
    return this;
  }

  /**
   * Drops the entire file bucket with all of its contents
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient drop() {
    return 
drop(ar -> { });
  }

  /**
   * Drops the entire file bucket with all of its contents
   * @return 
   */
  public io.reactivex.Completable rxDrop() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      drop($handler);
    });
  }

  /**
   * Finds all file ids in the bucket
   * @param resultHandler called when the list of file ids is available
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient findAllIds(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> resultHandler) { 
    delegate.findAllIds(resultHandler);
    return this;
  }

  /**
   * Finds all file ids in the bucket
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient findAllIds() {
    return 
findAllIds(ar -> { });
  }

  /**
   * Finds all file ids in the bucket
   * @return 
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxFindAllIds() { 
    return AsyncResultSingle.toSingle($handler -> {
      findAllIds($handler);
    });
  }

  /**
   * Finds all file ids that match a query.
   * @param query a bson query expressed as json that will be used to match files
   * @param resultHandler called when the list of file ids is available
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient findIds(io.vertx.core.json.JsonObject query, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<java.lang.String>>> resultHandler) { 
    delegate.findIds(query, resultHandler);
    return this;
  }

  /**
   * Finds all file ids that match a query.
   * @param query a bson query expressed as json that will be used to match files
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient findIds(io.vertx.core.json.JsonObject query) {
    return 
findIds(query, ar -> { });
  }

  /**
   * Finds all file ids that match a query.
   * @param query a bson query expressed as json that will be used to match files
   * @return 
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxFindIds(io.vertx.core.json.JsonObject query) { 
    return AsyncResultSingle.toSingle($handler -> {
      findIds(query, $handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadByFileName(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.uploadByFileName(stream.getDelegate(), fileName, resultHandler);
    return this;
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadByFileName(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName) {
    return 
uploadByFileName(stream, fileName, ar -> { });
  }

  public io.reactivex.Single<java.lang.String> rxUploadByFileName(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      uploadByFileName(stream, fileName, $handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadByFileName(io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.uploadByFileName(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume(), fileName, resultHandler);
    return this;
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadByFileName(io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName) {
    return 
uploadByFileName(stream, fileName, ar -> { });
  }

  public io.reactivex.Single<java.lang.String> rxUploadByFileName(io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      uploadByFileName(stream, fileName, $handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadByFileNameWithOptions(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.uploadByFileNameWithOptions(stream.getDelegate(), fileName, options, resultHandler);
    return this;
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadByFileNameWithOptions(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) {
    return 
uploadByFileNameWithOptions(stream, fileName, options, ar -> { });
  }

  public io.reactivex.Single<java.lang.String> rxUploadByFileNameWithOptions(io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      uploadByFileNameWithOptions(stream, fileName, options, $handler);
    });
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadByFileNameWithOptions(io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.uploadByFileNameWithOptions(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(stream, obj -> obj.getDelegate()).resume(), fileName, options, resultHandler);
    return this;
  }

  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadByFileNameWithOptions(io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) {
    return 
uploadByFileNameWithOptions(stream, fileName, options, ar -> { });
  }

  public io.reactivex.Single<java.lang.String> rxUploadByFileNameWithOptions(io.reactivex.Flowable<io.vertx.reactivex.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      uploadByFileNameWithOptions(stream, fileName, options, $handler);
    });
  }

  /**
   * Upload a file to gridfs
   * @param fileName the name of the file to store in gridfs
   * @param resultHandler the id of the file that was uploaded
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadFile(java.lang.String fileName, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.uploadFile(fileName, resultHandler);
    return this;
  }

  /**
   * Upload a file to gridfs
   * @param fileName the name of the file to store in gridfs
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadFile(java.lang.String fileName) {
    return 
uploadFile(fileName, ar -> { });
  }

  /**
   * Upload a file to gridfs
   * @param fileName the name of the file to store in gridfs
   * @return 
   */
  public io.reactivex.Single<java.lang.String> rxUploadFile(java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      uploadFile(fileName, $handler);
    });
  }

  /**
   * Upload a file to gridfs with options
   * @param fileName the name of the file to store in gridfs
   * @param options {@link io.vertx.ext.mongo.GridFsUploadOptions} for specifying metadata and chunk size
   * @param resultHandler the id of the file that was uploaded
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadFileWithOptions(java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.String>> resultHandler) { 
    delegate.uploadFileWithOptions(fileName, options, resultHandler);
    return this;
  }

  /**
   * Upload a file to gridfs with options
   * @param fileName the name of the file to store in gridfs
   * @param options {@link io.vertx.ext.mongo.GridFsUploadOptions} for specifying metadata and chunk size
   * @return 
   */
  public io.vertx.reactivex.ext.mongo.MongoGridFsClient uploadFileWithOptions(java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) {
    return 
uploadFileWithOptions(fileName, options, ar -> { });
  }

  /**
   * Upload a file to gridfs with options
   * @param fileName the name of the file to store in gridfs
   * @param options {@link io.vertx.ext.mongo.GridFsUploadOptions} for specifying metadata and chunk size
   * @return 
   */
  public io.reactivex.Single<java.lang.String> rxUploadFileWithOptions(java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      uploadFileWithOptions(fileName, options, $handler);
    });
  }

  /**
   * Close the client and release its resources
   */
  public void close() { 
    delegate.close();
  }

  public static MongoGridFsClient newInstance(io.vertx.ext.mongo.MongoGridFsClient arg) {
    return arg != null ? new MongoGridFsClient(arg) : null;
  }

}
