/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.ldap;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating a LDAP {@link io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.ldap.LdapAuthentication original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.ldap.LdapAuthentication.class)
public class LdapAuthentication extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LdapAuthentication that = (LdapAuthentication) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<LdapAuthentication> __TYPE_ARG = new TypeArg<>(    obj -> new LdapAuthentication((io.vertx.ext.auth.ldap.LdapAuthentication) obj),
    LdapAuthentication::getDelegate
  );

  private final io.vertx.ext.auth.ldap.LdapAuthentication delegate;
  
  public LdapAuthentication(io.vertx.ext.auth.ldap.LdapAuthentication delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public LdapAuthentication(Object delegate) {
    super((io.vertx.ext.auth.ldap.LdapAuthentication)delegate);
    this.delegate = (io.vertx.ext.auth.ldap.LdapAuthentication)delegate;
  }

  public io.vertx.ext.auth.ldap.LdapAuthentication getDelegate() {
    return delegate;
  }

  /**
   * Create a LDAP authentication provider
   * @param vertx the Vert.x instance
   * @param options the ldap options
   * @return the authentication provider
   */
  public static io.vertx.reactivex.ext.auth.ldap.LdapAuthentication create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.ldap.LdapAuthenticationOptions options) { 
    io.vertx.reactivex.ext.auth.ldap.LdapAuthentication ret = io.vertx.reactivex.ext.auth.ldap.LdapAuthentication.newInstance((io.vertx.ext.auth.ldap.LdapAuthentication)io.vertx.ext.auth.ldap.LdapAuthentication.create(vertx.getDelegate(), options));
    return ret;
  }

  public static LdapAuthentication newInstance(io.vertx.ext.auth.ldap.LdapAuthentication arg) {
    return arg != null ? new LdapAuthentication(arg) : null;
  }

}
