/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.jdbc;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jdbc.JDBCUserUtil original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.jdbc.JDBCUserUtil.class)
public class JDBCUserUtil {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCUserUtil that = (JDBCUserUtil) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JDBCUserUtil> __TYPE_ARG = new TypeArg<>(    obj -> new JDBCUserUtil((io.vertx.ext.auth.jdbc.JDBCUserUtil) obj),
    JDBCUserUtil::getDelegate
  );

  private final io.vertx.ext.auth.jdbc.JDBCUserUtil delegate;
  
  public JDBCUserUtil(io.vertx.ext.auth.jdbc.JDBCUserUtil delegate) {
    this.delegate = delegate;
  }

  public JDBCUserUtil(Object delegate) {
    this.delegate = (io.vertx.ext.auth.jdbc.JDBCUserUtil)delegate;
  }

  public io.vertx.ext.auth.jdbc.JDBCUserUtil getDelegate() {
    return delegate;
  }

  /**
   * Create an instance of the user helper.
   * @param client the client with write rights to the database.
   * @return the instance
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil create(io.vertx.reactivex.ext.jdbc.JDBCClient client) { 
    io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil ret = io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil.newInstance((io.vertx.ext.auth.jdbc.JDBCUserUtil)io.vertx.ext.auth.jdbc.JDBCUserUtil.create(client.getDelegate()));
    return ret;
  }

  /**
   * Create an instance of the user helper with custom queries.
   * @param client the client with write rights to the database.
   * @param insertUserSQL 
   * @param insertUserRoleSQL 
   * @param insertRolePermissionSQL 
   * @return the instance
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil create(io.vertx.reactivex.ext.jdbc.JDBCClient client, java.lang.String insertUserSQL, java.lang.String insertUserRoleSQL, java.lang.String insertRolePermissionSQL) { 
    io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil ret = io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil.newInstance((io.vertx.ext.auth.jdbc.JDBCUserUtil)io.vertx.ext.auth.jdbc.JDBCUserUtil.create(client.getDelegate(), insertUserSQL, insertUserRoleSQL, insertRolePermissionSQL));
    return ret;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil createUser(java.lang.String username, java.lang.String password, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createUser(username, password, resultHandler);
    return this;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil createUser(java.lang.String username, java.lang.String password) {
    return 
createUser(username, password, ar -> { });
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @return fluent self
   */
  @Deprecated()
  public io.reactivex.Completable rxCreateUser(java.lang.String username, java.lang.String password) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createUser(username, password, $handler);
    });
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil createHashedUser(java.lang.String username, java.lang.String hash, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createHashedUser(username, hash, resultHandler);
    return this;
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil createHashedUser(java.lang.String username, java.lang.String hash) {
    return 
createHashedUser(username, hash, ar -> { });
  }

  /**
   * Insert a user into a database.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @return fluent self
   */
  @Deprecated()
  public io.reactivex.Completable rxCreateHashedUser(java.lang.String username, java.lang.String hash) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createHashedUser(username, hash, $handler);
    });
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param role a to be set
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil createUserRole(java.lang.String username, java.lang.String role, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createUserRole(username, role, resultHandler);
    return this;
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param role a to be set
   * @return fluent self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil createUserRole(java.lang.String username, java.lang.String role) {
    return 
createUserRole(username, role, ar -> { });
  }

  /**
   * Insert a user role into a database.
   * @param username the username to be set
   * @param role a to be set
   * @return fluent self
   */
  @Deprecated()
  public io.reactivex.Completable rxCreateUserRole(java.lang.String username, java.lang.String role) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createUserRole(username, role, $handler);
    });
  }

  /**
   * Insert a role permission into a database.
   * @param role a to be set
   * @param permission the permission to be set
   * @param resultHandler the ResultHandler will be provided with the result of the operation
   * @return fluent self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil createRolePermission(java.lang.String role, java.lang.String permission, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> resultHandler) { 
    delegate.createRolePermission(role, permission, resultHandler);
    return this;
  }

  /**
   * Insert a role permission into a database.
   * @param role a to be set
   * @param permission the permission to be set
   * @return fluent self
   */
  @Deprecated()
  public io.vertx.reactivex.ext.auth.jdbc.JDBCUserUtil createRolePermission(java.lang.String role, java.lang.String permission) {
    return 
createRolePermission(role, permission, ar -> { });
  }

  /**
   * Insert a role permission into a database.
   * @param role a to be set
   * @param permission the permission to be set
   * @return fluent self
   */
  @Deprecated()
  public io.reactivex.Completable rxCreateRolePermission(java.lang.String role, java.lang.String permission) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      createRolePermission(role, permission, $handler);
    });
  }

  public static JDBCUserUtil newInstance(io.vertx.ext.auth.jdbc.JDBCUserUtil arg) {
    return arg != null ? new JDBCUserUtil(arg) : null;
  }

}
